/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.operation;

import com.atlassian.nutcluster.config.WanPublisherState;
import com.atlassian.nutcluster.spi.AbstractLocalOperation;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.wan.WanReplicationService;

public class ChangeWanStateOperation
extends AbstractLocalOperation {
    private String schemeName;
    private String publisherName;
    private WanPublisherState state;

    public ChangeWanStateOperation(String schemeName, String publisherName, WanPublisherState state) {
        this.schemeName = schemeName;
        this.publisherName = publisherName;
        this.state = state;
    }

    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        switch (this.state) {
            case REPLICATING: {
                wanReplicationService.resume(this.schemeName, this.publisherName);
                break;
            }
            case PAUSED: {
                wanReplicationService.pause(this.schemeName, this.publisherName);
                break;
            }
            case STOPPED: {
                wanReplicationService.stop(this.schemeName, this.publisherName);
                break;
            }
        }
    }
}

