/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.management.request;

import com.atlassian.nutcluster.config.WanPublisherState;
import com.atlassian.nutcluster.internal.json.JsonObject;
import com.atlassian.nutcluster.internal.management.ManagementCenterService;
import com.atlassian.nutcluster.internal.management.operation.ChangeWanStateOperation;
import com.atlassian.nutcluster.internal.management.request.ConsoleRequest;
import com.atlassian.nutcluster.util.JsonUtil;

public class ChangeWanStateRequest
implements ConsoleRequest {
    private String schemeName;
    private String publisherName;
    private WanPublisherState state;

    public ChangeWanStateRequest() {
    }

    public ChangeWanStateRequest(String schemeName, String publisherName, WanPublisherState state) {
        this.schemeName = schemeName;
        this.publisherName = publisherName;
        this.state = state;
    }

    @Override
    public int getType() {
        return 33;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) {
        out.add("result", mcs.syncCallOnThis(new ChangeWanStateOperation(this.schemeName, this.publisherName, this.state)));
    }

    @Override
    public void fromJson(JsonObject json) {
        this.schemeName = JsonUtil.getString(json, "schemeName");
        this.publisherName = JsonUtil.getString(json, "publisherName");
        this.state = WanPublisherState.valueOf(JsonUtil.getString(json, "state"));
    }
}

