/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.partition.impl;

import com.atlassian.nutcluster.core.MigrationEvent;
import com.atlassian.nutcluster.core.MigrationListener;
import com.atlassian.nutcluster.partition.PartitionEventListener;

class MigrationListenerAdapter
implements PartitionEventListener<MigrationEvent> {
    private final MigrationListener migrationListener;

    public MigrationListenerAdapter(MigrationListener migrationListener) {
        this.migrationListener = migrationListener;
    }

    @Override
    public void onEvent(MigrationEvent migrationEvent) {
        MigrationEvent.MigrationStatus status = migrationEvent.getStatus();
        switch (status) {
            case STARTED: {
                this.migrationListener.migrationStarted(migrationEvent);
                break;
            }
            case COMPLETED: {
                this.migrationListener.migrationCompleted(migrationEvent);
                break;
            }
            case FAILED: {
                this.migrationListener.migrationFailed(migrationEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a known MigrationStatus: " + String.valueOf((Object)status));
            }
        }
    }
}

