/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.partition.operation;

import com.atlassian.nutcluster.core.MigrationEvent;
import com.atlassian.nutcluster.internal.partition.MigrationInfo;
import com.atlassian.nutcluster.internal.partition.impl.InternalPartitionServiceImpl;
import com.atlassian.nutcluster.internal.partition.impl.PartitionStateManager;
import com.atlassian.nutcluster.internal.partition.operation.AbstractPromotionOperation;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.spi.MigrationAwareService;
import com.atlassian.nutcluster.spi.PartitionMigrationEvent;

final class BeforePromotionOperation
extends AbstractPromotionOperation {
    private Runnable beforePromotionsCallback;

    public BeforePromotionOperation() {
        super(null);
    }

    BeforePromotionOperation(MigrationInfo migrationInfo, Runnable beforePromotionsCallback) {
        super(migrationInfo);
        this.beforePromotionsCallback = beforePromotionsCallback;
    }

    @Override
    public void beforeRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.STARTED);
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = service.getPartitionStateManager();
        if (!partitionStateManager.trySetMigratingFlag(this.getPartitionId())) {
            throw new IllegalStateException("Cannot set migrating flag, probably previous migration's finalization is not completed yet.");
        }
    }

    @Override
    public void run() throws Exception {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Running before promotion for " + String.valueOf(this.getPartitionMigrationEvent()));
        }
        PartitionMigrationEvent event = this.getPartitionMigrationEvent();
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.beforeMigration(event);
            }
            catch (Throwable e) {
                logger.warning("While promoting " + String.valueOf(this.getPartitionMigrationEvent()), e);
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.beforePromotionsCallback != null) {
            this.beforePromotionsCallback.run();
        }
    }
}

