/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.partition.operation;

import com.atlassian.nutcluster.internal.partition.InternalPartitionService;
import com.atlassian.nutcluster.internal.partition.MigrationCycleOperation;
import com.atlassian.nutcluster.internal.partition.NonFragmentedServiceNamespace;
import com.atlassian.nutcluster.internal.partition.PartitionReplica;
import com.atlassian.nutcluster.internal.partition.PartitionReplicaVersionManager;
import com.atlassian.nutcluster.internal.partition.ReplicaErrorLogger;
import com.atlassian.nutcluster.internal.partition.impl.InternalPartitionImpl;
import com.atlassian.nutcluster.internal.partition.impl.InternalPartitionServiceImpl;
import com.atlassian.nutcluster.internal.partition.impl.PartitionStateManager;
import com.atlassian.nutcluster.internal.partition.operation.AbstractPartitionOperation;
import com.atlassian.nutcluster.internal.partition.operation.PartitionReplicaSyncResponse;
import com.atlassian.nutcluster.internal.partition.operation.PartitionReplicaSyncRetryResponse;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.impl.Versioned;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.OperationService;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import com.atlassian.nutcluster.spi.PartitionReplicationEvent;
import com.atlassian.nutcluster.spi.ServiceNamespace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class PartitionReplicaSyncRequest
extends AbstractPartitionOperation
implements PartitionAwareOperation,
MigrationCycleOperation,
Versioned {
    private List<ServiceNamespace> namespaces;

    public PartitionReplicaSyncRequest() {
        this.namespaces = Collections.emptyList();
    }

    public PartitionReplicaSyncRequest(int partitionId, List<ServiceNamespace> namespaces, int replicaIndex) {
        this.namespaces = namespaces;
        this.setPartitionId(partitionId);
        this.setReplicaIndex(replicaIndex);
    }

    @Override
    public void beforeRun() {
        int syncReplicaIndex = this.getReplicaIndex();
        if (syncReplicaIndex < 1 || syncReplicaIndex > 6) {
            throw new IllegalArgumentException("Replica index " + syncReplicaIndex + " should be in the range [1-6]");
        }
    }

    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        if (!partitionService.areMigrationTasksAllowed()) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Migration is paused! Cannot process request. partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + String.valueOf(this.namespaces));
            }
            this.sendRetryResponse();
            return;
        }
        if (!this.checkPartitionOwner()) {
            this.sendRetryResponse();
            return;
        }
        int permits = partitionService.getReplicaManager().tryAcquireReplicaSyncPermits(this.namespaces.size());
        if (permits == 0) {
            this.logNotEnoughPermits();
            this.sendRetryResponse();
            return;
        }
        this.sendOperationsForNamespaces(permits);
        if (!this.namespaces.isEmpty()) {
            this.logNotEnoughPermits();
            this.sendRetryResponse();
        }
    }

    private void logNotEnoughPermits() {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Not enough permits available! Cannot process request. partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + String.valueOf(this.namespaces));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOperationsForNamespaces(int permits) {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        try {
            PartitionReplicationEvent event = new PartitionReplicationEvent(this.getPartitionId(), this.getReplicaIndex());
            Iterator<ServiceNamespace> iterator = this.namespaces.iterator();
            for (int i = 0; i < permits; ++i) {
                ServiceNamespace namespace = iterator.next();
                Collection<Operation> operations = NonFragmentedServiceNamespace.INSTANCE.equals(namespace) ? this.createNonFragmentedReplicationOperations(event) : this.createFragmentReplicationOperations(event, namespace);
                this.sendOperations(operations, namespace);
                iterator.remove();
            }
        }
        finally {
            partitionService.getReplicaManager().releaseReplicaSyncPermits(permits);
        }
    }

    private void sendOperations(Collection<Operation> operations, ServiceNamespace ns) {
        if (operations.isEmpty()) {
            this.logNoReplicaDataFound(this.getPartitionId(), ns, this.getReplicaIndex());
            this.sendResponse(null, ns);
        } else {
            this.sendResponse(operations, ns);
        }
    }

    private boolean checkPartitionOwner() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(this.getPartitionId());
        PartitionReplica owner = partition.getOwnerReplicaOrNull();
        NodeEngine nodeEngine = this.getNodeEngine();
        if (owner == null || !owner.isIdentical(nodeEngine.getLocalMember())) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("This node is not owner partition. Cannot process request. partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + String.valueOf(this.namespaces));
            }
            return false;
        }
        return true;
    }

    private void sendRetryResponse() {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionReplicaSyncRetryResponse response = new PartitionReplicaSyncRetryResponse(this.namespaces);
        response.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        Address target = this.getCallerAddress();
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(response, target);
    }

    private void sendResponse(Collection<Operation> operations, ServiceNamespace ns) {
        NodeEngine nodeEngine = this.getNodeEngine();
        PartitionReplicaSyncResponse syncResponse = this.createResponse(operations, ns);
        Address target = this.getCallerAddress();
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Sending sync response to -> " + String.valueOf(target) + " for partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + String.valueOf(ns));
        }
        syncResponse.setTarget(target);
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(syncResponse, target);
    }

    private PartitionReplicaSyncResponse createResponse(Collection<Operation> operations, ServiceNamespace ns) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        PartitionReplicaVersionManager versionManager = partitionService.getPartitionReplicaVersionManager();
        long[] versions = versionManager.getPartitionReplicaVersions(partitionId, ns);
        PartitionReplicaSyncResponse syncResponse = new PartitionReplicaSyncResponse(operations, ns, versions);
        syncResponse.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        return syncResponse;
    }

    private void logNoReplicaDataFound(int partitionId, ServiceNamespace namespace, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("No replica data is found for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ", namespace= " + String.valueOf(namespace));
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.namespaces.size());
        for (ServiceNamespace namespace : this.namespaces) {
            out.writeObject(namespace);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        this.namespaces = new ArrayList<ServiceNamespace>(len);
        for (int i = 0; i < len; ++i) {
            ServiceNamespace ns = (ServiceNamespace)in.readObject();
            this.namespaces.add(ns);
        }
    }

    @Override
    public int getId() {
        return 11;
    }
}

