/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.partition.operation;

import com.atlassian.nutcluster.core.MemberLeftException;
import com.atlassian.nutcluster.internal.partition.MigrationCycleOperation;
import com.atlassian.nutcluster.internal.partition.MigrationInfo;
import com.atlassian.nutcluster.internal.partition.impl.InternalPartitionServiceImpl;
import com.atlassian.nutcluster.internal.partition.operation.AbstractPartitionOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.ExceptionAction;
import com.atlassian.nutcluster.spi.exception.TargetNotMemberException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PublishCompletedMigrationsOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation {
    private Collection<MigrationInfo> completedMigrations;
    private transient boolean success;

    public PublishCompletedMigrationsOperation() {
    }

    public PublishCompletedMigrationsOperation(Collection<MigrationInfo> completedMigrations) {
        this.completedMigrations = completedMigrations;
    }

    @Override
    public void run() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        this.success = service.applyCompletedMigrations(this.completedMigrations, this.getCallerAddress());
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int len = in.readInt();
        this.completedMigrations = new ArrayList<MigrationInfo>(len);
        for (int i = 0; i < len; ++i) {
            MigrationInfo migrationInfo = (MigrationInfo)in.readObject();
            this.completedMigrations.add(migrationInfo);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int len = this.completedMigrations.size();
        out.writeInt(len);
        for (MigrationInfo migrationInfo : this.completedMigrations) {
            out.writeObject(migrationInfo);
        }
    }

    @Override
    public int getId() {
        return 22;
    }
}

