/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.util.comparators;

import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.internal.util.comparators.BinaryValueComparator;
import com.atlassian.nutcluster.internal.util.comparators.ObjectValueComparator;
import com.atlassian.nutcluster.internal.util.comparators.ValueComparator;

public final class ValueComparatorUtil {
    private ValueComparatorUtil() {
    }

    public static ValueComparator getValueComparatorOf(InMemoryFormat inMemoryFormat) {
        switch (inMemoryFormat) {
            case BINARY: {
                return BinaryValueComparator.INSTANCE;
            }
            case OBJECT: {
                return ObjectValueComparator.INSTANCE;
            }
            case NATIVE: {
                throw new IllegalArgumentException("Native storage format is supported in Nutcluster Enterprise only. Make sure you have Nutcluster Enterprise JARs on your classpath !");
            }
        }
        throw new IllegalArgumentException("Invalid storage format: " + String.valueOf((Object)inMemoryFormat));
    }
}

