/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.map.EntryBackupProcessor;
import com.atlassian.nutcluster.map.EntryProcessor;
import com.atlassian.nutcluster.nio.serialization.SerializableByConvention;
import java.util.Map;

public abstract class AbstractEntryProcessor<K, V>
implements EntryProcessor<K, V> {
    private final EntryBackupProcessor<K, V> entryBackupProcessor;

    public AbstractEntryProcessor() {
        this(true);
    }

    public AbstractEntryProcessor(boolean applyOnBackup) {
        this.entryBackupProcessor = applyOnBackup ? new EntryBackupProcessorImpl() : null;
    }

    @Override
    public final EntryBackupProcessor<K, V> getBackupProcessor() {
        return this.entryBackupProcessor;
    }

    @SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
    private class EntryBackupProcessorImpl
    implements EntryBackupProcessor<K, V>,
    NutclusterInstanceAware {
        static final long serialVersionUID = -5081502753526394129L;

        private EntryBackupProcessorImpl() {
        }

        @Override
        public void processBackup(Map.Entry<K, V> entry) {
            AbstractEntryProcessor.this.process(entry);
        }

        @Override
        public void setNutclusterInstance(NutclusterInstance NutclusterInstance2) {
            AbstractEntryProcessor outer = AbstractEntryProcessor.this;
            if (outer instanceof NutclusterInstanceAware) {
                ((NutclusterInstanceAware)((Object)outer)).setNutclusterInstance(NutclusterInstance2);
            }
        }
    }
}

