/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.map.impl.AbstractMapServiceFactory;
import com.atlassian.nutcluster.map.impl.MapClientAwareService;
import com.atlassian.nutcluster.map.impl.MapManagedService;
import com.atlassian.nutcluster.map.impl.MapMigrationAwareService;
import com.atlassian.nutcluster.map.impl.MapPartitionAwareService;
import com.atlassian.nutcluster.map.impl.MapPostJoinAwareService;
import com.atlassian.nutcluster.map.impl.MapQuorumAwareService;
import com.atlassian.nutcluster.map.impl.MapRemoteService;
import com.atlassian.nutcluster.map.impl.MapReplicationSupportingService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.MapSplitBrainHandlerService;
import com.atlassian.nutcluster.map.impl.MapStatisticsAwareService;
import com.atlassian.nutcluster.map.impl.MapTransactionalService;
import com.atlassian.nutcluster.map.impl.event.MapEventPublishingService;
import com.atlassian.nutcluster.spi.ClientAwareService;
import com.atlassian.nutcluster.spi.EventPublishingService;
import com.atlassian.nutcluster.spi.ManagedService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.PostJoinAwareService;
import com.atlassian.nutcluster.spi.RemoteService;
import com.atlassian.nutcluster.spi.ReplicationSupportingService;
import com.atlassian.nutcluster.spi.SplitBrainHandlerService;
import com.atlassian.nutcluster.spi.StatisticsAwareService;
import com.atlassian.nutcluster.spi.TransactionalService;
import com.atlassian.nutcluster.spi.impl.CountingMigrationAwareService;
import com.atlassian.nutcluster.util.Preconditions;

class DefaultMapServiceFactory
extends AbstractMapServiceFactory {
    private final NodeEngine nodeEngine;
    private final MapServiceContext mapServiceContext;

    public DefaultMapServiceFactory(NodeEngine nodeEngine, MapServiceContext mapServiceContext) {
        this.nodeEngine = Preconditions.checkNotNull(nodeEngine, "nodeEngine should not be null");
        this.mapServiceContext = Preconditions.checkNotNull(mapServiceContext, "mapServiceContext should not be null");
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    ManagedService createManagedService() {
        return new MapManagedService(this.mapServiceContext);
    }

    @Override
    CountingMigrationAwareService createMigrationAwareService() {
        return new CountingMigrationAwareService(new MapMigrationAwareService(this.mapServiceContext));
    }

    @Override
    TransactionalService createTransactionalService() {
        return new MapTransactionalService(this.mapServiceContext);
    }

    @Override
    RemoteService createRemoteService() {
        return new MapRemoteService(this.mapServiceContext);
    }

    @Override
    EventPublishingService createEventPublishingService() {
        return new MapEventPublishingService(this.mapServiceContext);
    }

    @Override
    PostJoinAwareService createPostJoinAwareService() {
        return new MapPostJoinAwareService(this.mapServiceContext);
    }

    @Override
    SplitBrainHandlerService createSplitBrainHandlerService() {
        return new MapSplitBrainHandlerService(this.mapServiceContext);
    }

    @Override
    ReplicationSupportingService createReplicationSupportingService() {
        return new MapReplicationSupportingService(this.mapServiceContext);
    }

    @Override
    StatisticsAwareService createStatisticsAwareService() {
        return new MapStatisticsAwareService(this.mapServiceContext);
    }

    @Override
    MapPartitionAwareService createPartitionAwareService() {
        return new MapPartitionAwareService(this.mapServiceContext);
    }

    @Override
    MapQuorumAwareService createQuorumAwareService() {
        return new MapQuorumAwareService(this.getMapServiceContext());
    }

    @Override
    ClientAwareService createClientAwareService() {
        return new MapClientAwareService(this.getMapServiceContext());
    }
}

