/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.core.IMapEvent;
import com.atlassian.nutcluster.map.impl.ListenerAdapter;
import com.atlassian.nutcluster.map.impl.MapListenerAdaptors;
import com.atlassian.nutcluster.map.listener.MapListener;
import com.atlassian.nutcluster.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class InternalMapListenerAdapter
implements ListenerAdapter<IMapEvent> {
    private final ListenerAdapter[] listenerAdapters;

    InternalMapListenerAdapter(MapListener mapListener) {
        Preconditions.isNotNull(mapListener, "mapListener");
        this.listenerAdapters = MapListenerAdaptors.createListenerAdapters(mapListener);
    }

    @Override
    public void onEvent(IMapEvent event) {
        EntryEventType eventType = event.getEventType();
        if (eventType == null) {
            return;
        }
        ListenerAdapter listenerAdapter = this.listenerAdapters[eventType.ordinal()];
        if (listenerAdapter == null) {
            return;
        }
        listenerAdapter.onEvent(event);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="listenerAdapters internal state is never changed")
    public ListenerAdapter[] getListenerAdapters() {
        return this.listenerAdapters;
    }
}

