/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.core.NutclusterJsonValue;
import com.atlassian.nutcluster.json.internal.JsonSchemaHelper;
import com.atlassian.nutcluster.json.internal.JsonSchemaNode;
import com.atlassian.nutcluster.map.impl.MetadataInitializer;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JsonMetadataInitializer
implements MetadataInitializer {
    public static final JsonMetadataInitializer INSTANCE = new JsonMetadataInitializer();
    private static final int UTF_CHAR_COUNT_FIELD_SIZE = 4;
    private static final JsonFactory FACTORY = new JsonFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createFromData(Data data) throws IOException {
        if (data.isJson()) {
            try (JsonParser parser = FACTORY.createParser((InputStream)new ByteArrayInputStream(data.toByteArray(), 12, data.dataSize() - 4));){
                JsonSchemaNode jsonSchemaNode = JsonSchemaHelper.createSchema(parser);
                return jsonSchemaNode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createFromObject(Object obj) throws IOException {
        if (obj instanceof NutclusterJsonValue) {
            String str = obj.toString();
            try (JsonParser parser = FACTORY.createParser(str);){
                JsonSchemaNode jsonSchemaNode = JsonSchemaHelper.createSchema(parser);
                return jsonSchemaNode;
            }
        }
        return null;
    }
}

