/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.map.impl.MapContainer;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.operation.PostJoinMapOperation;
import com.atlassian.nutcluster.map.impl.querycache.accumulator.AccumulatorInfo;
import com.atlassian.nutcluster.map.impl.querycache.publisher.MapPublisherRegistry;
import com.atlassian.nutcluster.map.impl.querycache.publisher.PartitionAccumulatorRegistry;
import com.atlassian.nutcluster.map.impl.querycache.publisher.PublisherContext;
import com.atlassian.nutcluster.map.impl.querycache.publisher.PublisherRegistry;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PostJoinAwareService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class MapPostJoinAwareService
implements PostJoinAwareService {
    private final MapServiceContext mapServiceContext;

    public MapPostJoinAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public Operation getPostJoinOperation() {
        PostJoinMapOperation postJoinOp = new PostJoinMapOperation();
        Map<String, MapContainer> mapContainers = this.mapServiceContext.getMapContainers();
        for (MapContainer mapContainer : mapContainers.values()) {
            postJoinOp.addMapInterceptors(mapContainer);
        }
        List<AccumulatorInfo> infoList = this.getAccumulatorInfoList();
        postJoinOp.setInfoList(infoList);
        postJoinOp.setNodeEngine(this.mapServiceContext.getNodeEngine());
        return postJoinOp;
    }

    private List<AccumulatorInfo> getAccumulatorInfoList() {
        ArrayList<AccumulatorInfo> infoList = new ArrayList<AccumulatorInfo>();
        PublisherContext publisherContext = this.mapServiceContext.getQueryCacheContext().getPublisherContext();
        MapPublisherRegistry mapPublisherRegistry = publisherContext.getMapPublisherRegistry();
        Map<String, PublisherRegistry> cachesOfMaps = mapPublisherRegistry.getAll();
        Collection<PublisherRegistry> publisherRegistries = cachesOfMaps.values();
        for (PublisherRegistry publisherRegistry : publisherRegistries) {
            Collection<PartitionAccumulatorRegistry> partitionAccumulatorRegistries = publisherRegistry.getAll().values();
            for (PartitionAccumulatorRegistry accumulatorRegistry : partitionAccumulatorRegistries) {
                AccumulatorInfo info = accumulatorRegistry.getInfo();
                infoList.add(info);
            }
        }
        return infoList;
    }
}

