/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.internal.config.ConfigValidator;
import com.atlassian.nutcluster.internal.config.MergePolicyValidator;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.proxy.MapProxyImpl;
import com.atlassian.nutcluster.map.impl.proxy.NearCachedMapProxyImpl;
import com.atlassian.nutcluster.map.merge.MergePolicyProvider;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.RemoteService;

class MapRemoteService
implements RemoteService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        Config config = this.nodeEngine.getConfig();
        MapConfig mapConfig = config.findMapConfig(name);
        MergePolicyProvider mergePolicyProvider = this.mapServiceContext.getMergePolicyProvider();
        ConfigValidator.checkMapConfig(mapConfig, mergePolicyProvider);
        Object mergePolicy = mergePolicyProvider.getMergePolicy(mapConfig.getMergePolicyConfig().getPolicy());
        MergePolicyValidator.checkMergePolicySupportsInMemoryFormat(name, mergePolicy, mapConfig.getInMemoryFormat(), true, this.nodeEngine.getLogger(this.getClass()));
        if (mapConfig.isNearCacheEnabled()) {
            ConfigValidator.checkNearCacheConfig(name, mapConfig.getNearCacheConfig(), config.getNativeMemoryConfig(), false);
            return new NearCachedMapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
        }
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.mapServiceContext.destroyMap(name);
    }
}

