/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl;

import com.atlassian.nutcluster.config.PartitioningStrategyConfig;
import com.atlassian.nutcluster.core.PartitioningStrategy;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.util.ExceptionUtil;
import java.util.concurrent.ConcurrentHashMap;

public final class PartitioningStrategyFactory {
    final ConcurrentHashMap<String, PartitioningStrategy> cache = new ConcurrentHashMap();
    private final ClassLoader configClassLoader;

    public PartitioningStrategyFactory(ClassLoader configClassLoader) {
        this.configClassLoader = configClassLoader;
    }

    public PartitioningStrategy getPartitioningStrategy(String mapName, PartitioningStrategyConfig config) {
        PartitioningStrategy strategy = null;
        if (config != null && (strategy = config.getPartitioningStrategy()) == null) {
            if (this.cache.containsKey(mapName)) {
                strategy = this.cache.get(mapName);
            } else if (config.getPartitioningStrategyClass() != null) {
                try {
                    strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.configClassLoader, config.getPartitioningStrategyClass());
                    this.cache.put(mapName, strategy);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
        }
        return strategy;
    }

    public void removePartitioningStrategyFromCache(String mapName) {
        this.cache.remove(mapName);
    }
}

