/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.eviction;

import com.atlassian.nutcluster.core.EntryView;
import com.atlassian.nutcluster.map.eviction.MapEvictionPolicy;
import com.atlassian.nutcluster.map.impl.eviction.EvictionChecker;
import com.atlassian.nutcluster.map.impl.eviction.Evictor;
import com.atlassian.nutcluster.map.impl.record.Record;
import com.atlassian.nutcluster.map.impl.recordstore.LazyEntryViewFromRecord;
import com.atlassian.nutcluster.map.impl.recordstore.RecordStore;
import com.atlassian.nutcluster.map.impl.recordstore.Storage;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.partition.IPartition;
import com.atlassian.nutcluster.spi.partition.IPartitionService;
import com.atlassian.nutcluster.util.Clock;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.ThreadUtil;

public class EvictorImpl
implements Evictor {
    protected final EvictionChecker evictionChecker;
    protected final IPartitionService partitionService;
    protected final MapEvictionPolicy mapEvictionPolicy;
    private final int batchSize;

    public EvictorImpl(MapEvictionPolicy mapEvictionPolicy, EvictionChecker evictionChecker, IPartitionService partitionService, int batchSize) {
        this.evictionChecker = Preconditions.checkNotNull(evictionChecker);
        this.partitionService = Preconditions.checkNotNull(partitionService);
        this.mapEvictionPolicy = Preconditions.checkNotNull(mapEvictionPolicy);
        this.batchSize = batchSize;
    }

    @Override
    public void evict(RecordStore recordStore, Data excludedKey) {
        ThreadUtil.assertRunningOnPartitionThread();
        for (int i = 0; i < this.batchSize; ++i) {
            EntryView evictableEntry = this.selectEvictableEntry(recordStore, excludedKey);
            if (evictableEntry == null) {
                return;
            }
            this.evictEntry(recordStore, evictableEntry);
        }
    }

    private EntryView selectEvictableEntry(RecordStore recordStore, Data excludedKey) {
        Iterable<EntryView> samples = this.getSamples(recordStore);
        EntryView excluded = null;
        EntryView selected = null;
        for (EntryView candidate : samples) {
            if (excludedKey != null && excluded == null && this.getDataKey(candidate).equals(excludedKey)) {
                excluded = candidate;
                continue;
            }
            if (selected == null) {
                selected = candidate;
                continue;
            }
            if (this.mapEvictionPolicy.compare(candidate, selected) >= 0) continue;
            selected = candidate;
        }
        return selected == null ? excluded : selected;
    }

    private Data getDataKey(EntryView candidate) {
        return this.getRecordFromEntryView(candidate).getKey();
    }

    private void evictEntry(RecordStore recordStore, EntryView selectedEntry) {
        Record record = this.getRecordFromEntryView(selectedEntry);
        Data key = record.getKey();
        if (recordStore.isLocked(record.getKey())) {
            return;
        }
        boolean backup = this.isBackup(recordStore);
        recordStore.evict(key, backup);
        if (!backup) {
            recordStore.doPostEvictionOperations(record);
        }
    }

    @Override
    public boolean checkEvictable(RecordStore recordStore) {
        ThreadUtil.assertRunningOnPartitionThread();
        return this.evictionChecker.checkEvictable(recordStore);
    }

    protected Record getRecordFromEntryView(EntryView selectedEntry) {
        return ((LazyEntryViewFromRecord)selectedEntry).getRecord();
    }

    protected boolean isBackup(RecordStore recordStore) {
        int partitionId = recordStore.getPartitionId();
        IPartition partition = this.partitionService.getPartition(partitionId, false);
        return !partition.isLocal();
    }

    protected Iterable<EntryView> getSamples(RecordStore recordStore) {
        Storage storage = recordStore.getStorage();
        return storage.getRandomSamples(SAMPLE_COUNT);
    }

    protected static long getNow() {
        return Clock.currentTimeMillis();
    }

    public String toString() {
        return "EvictorImpl{, mapEvictionPolicy=" + String.valueOf(this.mapEvictionPolicy) + ", batchSize=" + this.batchSize + "}";
    }
}

