/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.iterator;

import com.atlassian.nutcluster.map.impl.iterator.AbstractMapQueryPartitionIterator;
import com.atlassian.nutcluster.map.impl.operation.MapOperation;
import com.atlassian.nutcluster.map.impl.proxy.MapProxyImpl;
import com.atlassian.nutcluster.map.impl.query.QueryResult;
import com.atlassian.nutcluster.map.impl.query.QueryResultRow;
import com.atlassian.nutcluster.map.impl.query.ResultSegment;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.projection.Projection;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapQueryPartitionIterator<K, V, R>
extends AbstractMapQueryPartitionIterator<K, V, R> {
    private final MapProxyImpl<K, V> mapProxy;

    public MapQueryPartitionIterator(MapProxyImpl<K, V> mapProxy, int fetchSize, int partitionId, Predicate<K, V> predicate, Projection<Map.Entry<K, V>, R> projection) {
        super(mapProxy, fetchSize, partitionId, predicate, projection);
        this.mapProxy = mapProxy;
        this.advance();
    }

    @Override
    protected List<Data> fetch() {
        MapOperation op = this.mapProxy.getOperationProvider().createFetchWithQueryOperation(this.mapProxy.getName(), this.lastTableIndex, this.fetchSize, this.query);
        ResultSegment segment = this.invoke(op);
        QueryResult queryResult = (QueryResult)segment.getResult();
        ArrayList<Data> serialized = new ArrayList<Data>(queryResult.size());
        for (QueryResultRow row : queryResult) {
            serialized.add(row.getValue());
        }
        this.setLastTableIndex(serialized, segment.getNextTableIndexToReadFrom());
        return serialized;
    }

    private ResultSegment invoke(Operation operation) {
        InternalCompletableFuture future = this.mapProxy.getOperationService().invokeOnPartition(this.mapProxy.getServiceName(), operation, this.partitionId);
        return (ResultSegment)future.join();
    }

    @Override
    protected SerializationService getSerializationService() {
        return this.mapProxy.getNodeEngine().getSerializationService();
    }
}

