/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.mapstore;

import com.atlassian.nutcluster.config.MapStoreConfig;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.MapStoreWrapper;
import com.atlassian.nutcluster.map.impl.mapstore.EmptyMapDataStore;
import com.atlassian.nutcluster.map.impl.mapstore.MapDataStore;
import com.atlassian.nutcluster.map.impl.mapstore.MapStoreContext;
import com.atlassian.nutcluster.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.atlassian.nutcluster.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.atlassian.nutcluster.map.impl.mapstore.writebehind.WriteBehindQueues;
import com.atlassian.nutcluster.map.impl.mapstore.writebehind.WriteBehindStore;
import com.atlassian.nutcluster.map.impl.mapstore.writethrough.WriteThroughStore;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import java.util.concurrent.atomic.AtomicInteger;

public final class MapDataStores {
    public static final MapDataStore EMPTY_MAP_DATA_STORE = new EmptyMapDataStore();

    private MapDataStores() {
    }

    public static <K, V> MapDataStore<K, V> createWriteBehindStore(MapStoreContext mapStoreContext, int partitionId, WriteBehindProcessor writeBehindProcessor) {
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        MapStoreConfig mapStoreConfig = mapStoreContext.getMapStoreConfig();
        InternalSerializationService serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        WriteBehindStore mapDataStore = new WriteBehindStore(mapStoreContext, partitionId, serializationService);
        mapDataStore.setWriteBehindQueue(MapDataStores.newWriteBehindQueue(mapServiceContext, mapStoreConfig.isWriteCoalescing()));
        mapDataStore.setWriteBehindProcessor(writeBehindProcessor);
        return mapDataStore;
    }

    private static WriteBehindQueue newWriteBehindQueue(MapServiceContext mapServiceContext, boolean writeCoalescing) {
        NutclusterProperties nutclusterProperties = mapServiceContext.getNodeEngine().getProperties();
        int capacity = nutclusterProperties.getInteger(GroupProperty.MAP_WRITE_BEHIND_QUEUE_CAPACITY);
        AtomicInteger counter = mapServiceContext.getWriteBehindQueueItemCounter();
        return writeCoalescing ? WriteBehindQueues.createDefaultWriteBehindQueue() : WriteBehindQueues.createBoundedWriteBehindQueue(capacity, counter);
    }

    public static <K, V> MapDataStore<K, V> createWriteThroughStore(MapStoreContext mapStoreContext) {
        MapStoreWrapper store = mapStoreContext.getMapStoreWrapper();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        InternalSerializationService serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        return new WriteThroughStore(store, serializationService);
    }

    public static <K, V> MapDataStore<K, V> emptyStore() {
        return EMPTY_MAP_DATA_STORE;
    }
}

