/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.operation;

import com.atlassian.nutcluster.map.impl.operation.AddIndexBackupOperation;
import com.atlassian.nutcluster.map.impl.operation.MapOperation;
import com.atlassian.nutcluster.map.impl.record.Record;
import com.atlassian.nutcluster.map.impl.record.Records;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.query.impl.Index;
import com.atlassian.nutcluster.query.impl.Indexes;
import com.atlassian.nutcluster.query.impl.InternalIndex;
import com.atlassian.nutcluster.query.impl.QueryableEntry;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import com.atlassian.nutcluster.util.Clock;
import java.io.IOException;
import java.util.Iterator;

public class AddIndexOperation
extends MapOperation
implements PartitionAwareOperation,
MutatingOperation,
BackupAwareOperation {
    private String attributeName;
    private boolean ordered;

    public AddIndexOperation() {
    }

    public AddIndexOperation(String name, String attributeName, boolean ordered) {
        super(name);
        this.attributeName = attributeName;
        this.ordered = ordered;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new AddIndexBackupOperation(this.name, this.attributeName, this.ordered);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        Indexes indexes = this.mapContainer.getIndexes(partitionId);
        InternalIndex index = indexes.addOrGetIndex(this.attributeName, this.ordered);
        if (index.hasPartitionIndexed(partitionId)) {
            return;
        }
        long now = this.getNow();
        Iterator<Record> iterator = this.recordStore.iterator(now, false);
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data key = record.getKey();
            Object value = Records.getValueOrCachedValue(record, serializationService);
            QueryableEntry queryEntry = this.mapContainer.newQueryEntry(key, value);
            index.putEntry(queryEntry, null, Index.OperationSource.USER);
        }
        index.markPartitionAsIndexed(partitionId);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.attributeName);
        out.writeBoolean(this.ordered);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.attributeName = in.readUTF();
        this.ordered = in.readBoolean();
    }

    @Override
    public int getId() {
        return 43;
    }
}

