/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.operation;

import com.atlassian.nutcluster.concurrent.lock.LockWaitNotifyKey;
import com.atlassian.nutcluster.core.EntryView;
import com.atlassian.nutcluster.core.OperationTimeoutException;
import com.atlassian.nutcluster.map.impl.EntryViews;
import com.atlassian.nutcluster.map.impl.operation.ReadonlyKeyBasedMapOperation;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.BlockingOperation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;

public class GetEntryViewOperation
extends ReadonlyKeyBasedMapOperation
implements BlockingOperation {
    private EntryView<Data, Data> result;

    public GetEntryViewOperation() {
    }

    public GetEntryViewOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    public void run() {
        Object record = this.recordStore.getRecordOrNull(this.dataKey);
        if (record != null) {
            Data value = this.mapServiceContext.toData(record.getValue());
            this.result = EntryViews.createSimpleEntryView(this.dataKey, value, record);
        }
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(this.getServiceNamespace(), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return this.recordStore.isTransactionallyLocked(this.dataKey) && !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public int getId() {
        return 46;
    }
}

