/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.operation;

import com.atlassian.nutcluster.map.EntryBackupProcessor;
import com.atlassian.nutcluster.map.EntryProcessor;
import com.atlassian.nutcluster.map.impl.operation.MultipleEntryOperation;
import com.atlassian.nutcluster.map.impl.operation.MultipleEntryWithPredicateBackupOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.IOException;
import java.util.Set;

public class MultipleEntryWithPredicateOperation
extends MultipleEntryOperation {
    private Predicate predicate;

    public MultipleEntryWithPredicateOperation() {
    }

    public MultipleEntryWithPredicateOperation(String name, Set<Data> keys, EntryProcessor entryProcessor, Predicate predicate) {
        super(name, keys, entryProcessor);
        this.predicate = Preconditions.checkNotNull(predicate, "predicate cannot be null");
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return new MultipleEntryWithPredicateBackupOperation(this.name, this.keys, backupProcessor, this.predicate);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.predicate = (Predicate)in.readObject();
    }

    @Override
    public int getId() {
        return 54;
    }
}

