/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.operation;

import com.atlassian.nutcluster.core.ManagedContext;
import com.atlassian.nutcluster.map.EntryBackupProcessor;
import com.atlassian.nutcluster.map.EntryProcessor;
import com.atlassian.nutcluster.map.impl.MapEntries;
import com.atlassian.nutcluster.map.impl.operation.EntryOperator;
import com.atlassian.nutcluster.map.impl.operation.MapOperation;
import com.atlassian.nutcluster.map.impl.operation.PartitionWideEntryBackupOperation;
import com.atlassian.nutcluster.map.impl.record.Record;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import com.atlassian.nutcluster.util.Clock;
import java.io.IOException;
import java.util.Iterator;

public class PartitionWideEntryOperation
extends MapOperation
implements MutatingOperation,
PartitionAwareOperation,
BackupAwareOperation {
    protected MapEntries responses;
    protected EntryProcessor entryProcessor;
    protected transient EntryOperator operator;

    public PartitionWideEntryOperation() {
    }

    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    public void run() {
        this.responses = new MapEntries(this.recordStore.size());
        this.operator = EntryOperator.operator(this, this.entryProcessor, this.getPredicate());
        Iterator<Record> iterator = this.recordStore.iterator(Clock.currentTimeMillis(), false);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data dataKey = record.getKey();
            Data response = this.operator.operateOnKey(dataKey).doPostOperateOps().getResult();
            if (response == null) continue;
            this.responses.add(dataKey, response);
        }
    }

    @Override
    public Object getResponse() {
        return this.responses;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        PartitionWideEntryBackupOperation backupOperation = null;
        if (backupProcessor != null) {
            backupOperation = new PartitionWideEntryBackupOperation(this.name, backupProcessor);
        }
        return backupOperation;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", entryProcessor=").append(this.entryProcessor);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public int getId() {
        return 39;
    }
}

