/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.querycache.subscriber;

import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.core.IMapEvent;
import com.atlassian.nutcluster.core.MapEvent;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.map.EventLostEvent;
import com.atlassian.nutcluster.map.QueryCache;
import com.atlassian.nutcluster.map.impl.DataAwareEntryEvent;
import com.atlassian.nutcluster.map.impl.EntryEventFilter;
import com.atlassian.nutcluster.map.impl.event.EventData;
import com.atlassian.nutcluster.map.impl.querycache.QueryCacheContext;
import com.atlassian.nutcluster.map.impl.querycache.QueryCacheEventService;
import com.atlassian.nutcluster.map.impl.querycache.event.LocalCacheWideEventData;
import com.atlassian.nutcluster.map.impl.querycache.event.LocalEntryEventData;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.DefaultQueryCache;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.InternalQueryCache;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.SubscriberContext;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.record.QueryCacheRecord;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.query.impl.getters.Extractors;
import com.atlassian.nutcluster.spi.EventFilter;
import com.atlassian.nutcluster.spi.serialization.SerializationService;

public final class EventPublisherHelper {
    private EventPublisherHelper() {
    }

    static void publishEntryEvent(QueryCacheContext context, String mapName, String cacheId, Data dataKey, Data dataNewValue, QueryCacheRecord oldRecord, EntryEventType eventType, Extractors extractors) {
        if (!EventPublisherHelper.hasListener(context, mapName, cacheId)) {
            return;
        }
        QueryCacheEventService eventService = EventPublisherHelper.getQueryCacheEventService(context);
        Object oldValue = EventPublisherHelper.getOldValue(oldRecord);
        LocalEntryEventData eventData = EventPublisherHelper.createLocalEntryEventData(cacheId, dataKey, dataNewValue, oldValue, eventType.getType(), -1, context);
        eventService.publish(mapName, cacheId, eventData, dataKey.hashCode(), extractors);
    }

    public static boolean hasListener(QueryCache queryCache) {
        DefaultQueryCache defaultQueryCache = (DefaultQueryCache)queryCache;
        QueryCacheEventService eventService = EventPublisherHelper.getQueryCacheEventService(defaultQueryCache.context);
        return eventService.hasListener(defaultQueryCache.mapName, defaultQueryCache.cacheId);
    }

    private static boolean hasListener(QueryCacheContext context, String mapName, String cacheId) {
        QueryCacheEventService eventService = EventPublisherHelper.getQueryCacheEventService(context);
        return eventService.hasListener(mapName, cacheId);
    }

    static void publishCacheWideEvent(InternalQueryCache queryCache, int numberOfEntriesAffected, EntryEventType eventType) {
        if (!EventPublisherHelper.hasListener(queryCache)) {
            return;
        }
        DefaultQueryCache defaultQueryCache = (DefaultQueryCache)queryCache;
        QueryCacheContext context = defaultQueryCache.context;
        String mapName = defaultQueryCache.mapName;
        String cacheId = defaultQueryCache.cacheId;
        QueryCacheEventService eventService = EventPublisherHelper.getQueryCacheEventService(context);
        LocalCacheWideEventData eventData = new LocalCacheWideEventData(cacheId, eventType.getType(), numberOfEntriesAffected);
        eventService.publish(mapName, cacheId, eventData, cacheId.hashCode(), queryCache.getExtractors());
    }

    private static Object getOldValue(QueryCacheRecord oldRecord) {
        return oldRecord == null ? null : oldRecord.getValue();
    }

    private static LocalEntryEventData createLocalEntryEventData(String cacheId, Data dataKey, Data dataNewValue, Object oldValue, int eventType, int partitionId, QueryCacheContext context) {
        InternalSerializationService serializationService = context.getSerializationService();
        return new LocalEntryEventData(serializationService, cacheId, eventType, dataKey, oldValue, dataNewValue, partitionId);
    }

    private static QueryCacheEventService getQueryCacheEventService(QueryCacheContext context) {
        SubscriberContext subscriberContext = context.getSubscriberContext();
        return subscriberContext.getEventService();
    }

    public static void publishEventLost(QueryCacheContext context, String mapName, String cacheId, int partitionId, Extractors extractors) {
        QueryCacheEventService eventService = EventPublisherHelper.getQueryCacheEventService(context);
        int orderKey = cacheId.hashCode();
        eventService.publish(mapName, cacheId, EventPublisherHelper.createLocalEntryEventData(cacheId, null, null, null, EventLostEvent.EVENT_TYPE, partitionId, context), orderKey, extractors);
    }

    public static IMapEvent createIMapEvent(EventData eventData, EventFilter filter, Member member, SerializationService serializationService) {
        String source = eventData.getSource();
        int eventType = eventData.getEventType();
        if (eventType == EventLostEvent.EVENT_TYPE) {
            LocalEntryEventData localEventData = (LocalEntryEventData)eventData;
            int partitionId = localEventData.getPartitionId();
            return new EventLostEvent(source, null, partitionId);
        }
        if (eventType == EntryEventType.CLEAR_ALL.getType() || eventType == EntryEventType.EVICT_ALL.getType()) {
            LocalCacheWideEventData localCacheWideEventData = (LocalCacheWideEventData)eventData;
            int numberOfEntriesAffected = localCacheWideEventData.getNumberOfEntriesAffected();
            return new MapEvent(source, null, eventType, numberOfEntriesAffected);
        }
        LocalEntryEventData localEntryEventData = (LocalEntryEventData)eventData;
        Data dataKey = localEntryEventData.getKeyData();
        Data dataNewValue = localEntryEventData.getValueData();
        Data dataOldValue = localEntryEventData.getOldValueData();
        boolean includeValue = EventPublisherHelper.isIncludeValue(filter);
        return new DataAwareEntryEvent(member, eventType, source, dataKey, includeValue ? dataNewValue : null, includeValue ? dataOldValue : null, null, serializationService);
    }

    private static boolean isIncludeValue(EventFilter filter) {
        if (filter instanceof EntryEventFilter) {
            return ((EntryEventFilter)filter).isIncludeValue();
        }
        return true;
    }
}

