/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.querycache.subscriber;

import com.atlassian.nutcluster.core.IMapEvent;
import com.atlassian.nutcluster.map.impl.ListenerAdapter;
import com.atlassian.nutcluster.map.impl.querycache.QueryCacheContext;
import com.atlassian.nutcluster.map.impl.querycache.accumulator.Accumulator;
import com.atlassian.nutcluster.map.impl.querycache.accumulator.AccumulatorInfo;
import com.atlassian.nutcluster.map.impl.querycache.event.BatchEventData;
import com.atlassian.nutcluster.map.impl.querycache.event.BatchIMapEvent;
import com.atlassian.nutcluster.map.impl.querycache.event.QueryCacheEventData;
import com.atlassian.nutcluster.map.impl.querycache.event.SingleIMapEvent;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.MapSubscriberRegistry;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.SubscriberContext;
import com.atlassian.nutcluster.map.impl.querycache.subscriber.SubscriberRegistry;
import com.atlassian.nutcluster.spi.serialization.SerializationService;
import java.util.Collection;

public class SubscriberListener
implements ListenerAdapter<IMapEvent> {
    private final AccumulatorInfo info;
    private final Accumulator accumulator;
    private final SubscriberContext subscriberContext;
    private final SerializationService serializationService;

    public SubscriberListener(QueryCacheContext context, AccumulatorInfo info) {
        this.info = info;
        this.subscriberContext = context.getSubscriberContext();
        this.accumulator = this.createAccumulator();
        this.serializationService = context.getSerializationService();
    }

    @Override
    public void onEvent(IMapEvent iMapEvent) {
        if (iMapEvent instanceof SingleIMapEvent) {
            QueryCacheEventData eventData = ((SingleIMapEvent)iMapEvent).getEventData();
            eventData.setSerializationService(this.serializationService);
            this.accumulator.accumulate(eventData);
            return;
        }
        if (iMapEvent instanceof BatchIMapEvent) {
            BatchIMapEvent batchIMapEvent = (BatchIMapEvent)iMapEvent;
            BatchEventData batchEventData = batchIMapEvent.getBatchEventData();
            Collection<QueryCacheEventData> events = batchEventData.getEvents();
            for (QueryCacheEventData eventData : events) {
                eventData.setSerializationService(this.serializationService);
                this.accumulator.accumulate(eventData);
            }
            return;
        }
    }

    private Accumulator createAccumulator() {
        MapSubscriberRegistry mapSubscriberRegistry = this.subscriberContext.getMapSubscriberRegistry();
        SubscriberRegistry subscriberRegistry = mapSubscriberRegistry.getOrCreate(this.info.getMapName());
        return subscriberRegistry.getOrCreate(this.info.getCacheId());
    }
}

