/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.record;

import com.atlassian.nutcluster.config.CacheDeserializedValues;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.core.PartitioningStrategy;
import com.atlassian.nutcluster.map.impl.record.AbstractRecord;
import com.atlassian.nutcluster.map.impl.record.CachedDataRecord;
import com.atlassian.nutcluster.map.impl.record.CachedDataRecordWithStats;
import com.atlassian.nutcluster.map.impl.record.DataRecord;
import com.atlassian.nutcluster.map.impl.record.DataRecordWithStats;
import com.atlassian.nutcluster.map.impl.record.Record;
import com.atlassian.nutcluster.map.impl.record.RecordFactory;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.serialization.SerializationService;

public class DataRecordFactory
implements RecordFactory<Data> {
    private final SerializationService serializationService;
    private final PartitioningStrategy partitionStrategy;
    private final CacheDeserializedValues cacheDeserializedValues;
    private final boolean statisticsEnabled;

    public DataRecordFactory(MapConfig config, SerializationService serializationService, PartitioningStrategy partitionStrategy) {
        this.serializationService = serializationService;
        this.partitionStrategy = partitionStrategy;
        this.statisticsEnabled = config.isStatisticsEnabled();
        this.cacheDeserializedValues = config.getCacheDeserializedValues();
    }

    @Override
    public Record<Data> newRecord(Data key, Object value) {
        assert (value != null) : "value can not be null";
        Object data = this.serializationService.toData(value, this.partitionStrategy);
        AbstractRecord record = switch (this.cacheDeserializedValues) {
            case CacheDeserializedValues.NEVER -> this.statisticsEnabled ? new DataRecordWithStats((Data)data) : new DataRecord((Data)data);
            default -> this.statisticsEnabled ? new CachedDataRecordWithStats((Data)data) : new CachedDataRecord((Data)data);
        };
        record.setKey(key);
        return record;
    }

    @Override
    public void setValue(Record<Data> record, Object value) {
        assert (value != null) : "value can not be null";
        Data v = value instanceof Data ? (Data)value : this.serializationService.toData(value, this.partitionStrategy);
        record.setValue(v);
    }
}

