/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.map.impl.wan;

import com.atlassian.nutcluster.core.EntryView;
import com.atlassian.nutcluster.map.impl.wan.WanMapEntryView;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.wan.ReplicationEventObject;
import com.atlassian.nutcluster.wan.impl.DistributedServiceWanEventCounters;
import com.atlassian.nutcluster.wan.impl.WanDataSerializerHook;
import java.io.IOException;

public class MapReplicationUpdate
implements ReplicationEventObject,
IdentifiedDataSerializable {
    private String mapName;
    private Object mergePolicy;
    private WanMapEntryView<Data, Data> entryView;

    public MapReplicationUpdate() {
    }

    public MapReplicationUpdate(String mapName, Object mergePolicy, EntryView<Data, Data> entryView) {
        this.mergePolicy = mergePolicy;
        this.mapName = mapName;
        this.entryView = entryView instanceof WanMapEntryView ? (WanMapEntryView<Object, Object>)entryView : new WanMapEntryView<Data, Data>(entryView);
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public Object getMergePolicy() {
        return this.mergePolicy;
    }

    public void setMergePolicy(Object mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public WanMapEntryView<Data, Data> getEntryView() {
        return this.entryView;
    }

    public void setEntryView(WanMapEntryView<Data, Data> entryView) {
        this.entryView = entryView;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeObject(this.mergePolicy);
        out.writeObject(this.entryView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.mergePolicy = in.readObject();
        EntryView entryView = (EntryView)in.readObject();
        this.entryView = entryView instanceof WanMapEntryView ? (WanMapEntryView)entryView : new WanMapEntryView(entryView);
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void incrementEventCount(DistributedServiceWanEventCounters counters) {
        counters.incrementUpdate(this.mapName);
    }

    @Override
    public Data getKey() {
        return this.entryView.getKey();
    }
}

