/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.mapreduce.aggregation.impl;

import com.atlassian.nutcluster.mapreduce.aggregation.PropertyExtractor;
import com.atlassian.nutcluster.mapreduce.aggregation.Supplier;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AggregationsDataSerializerHook;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;

public class AcceptAllSupplier<KeyIn, ValueIn, ValueOut>
extends Supplier<KeyIn, ValueIn, ValueOut>
implements IdentifiedDataSerializable {
    private PropertyExtractor<ValueIn, ValueOut> propertyExtractor;

    AcceptAllSupplier() {
    }

    public AcceptAllSupplier(PropertyExtractor<ValueIn, ValueOut> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    @Override
    public ValueOut apply(Map.Entry<KeyIn, ValueIn> entry) {
        ValueIn value = entry.getValue();
        return (ValueOut)(this.propertyExtractor != null ? this.propertyExtractor.extract(value) : value);
    }

    @Override
    public int getFactoryId() {
        return AggregationsDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.propertyExtractor);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.propertyExtractor = (PropertyExtractor)in.readObject();
    }
}

