/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.mapreduce.aggregation.impl;

import com.atlassian.nutcluster.mapreduce.Collator;
import com.atlassian.nutcluster.mapreduce.Combiner;
import com.atlassian.nutcluster.mapreduce.CombinerFactory;
import com.atlassian.nutcluster.mapreduce.Mapper;
import com.atlassian.nutcluster.mapreduce.Reducer;
import com.atlassian.nutcluster.mapreduce.ReducerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.Supplier;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AbstractAggregationCombinerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AbstractAggregationReducerFactory;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.AggType;
import com.atlassian.nutcluster.mapreduce.aggregation.impl.SupplierConsumingMapper;
import com.atlassian.nutcluster.nio.serialization.BinaryInterface;
import java.util.Map;

public class ComparableMinAggregation<Key, Value>
implements AggType<Key, Value, Key, Comparable, Comparable, Comparable, Comparable> {
    @Override
    public Collator<Map.Entry<Key, Comparable>, Comparable> getCollator() {
        return new Collator<Map.Entry<Key, Comparable>, Comparable>(this){

            @Override
            public Comparable collate(Iterable<Map.Entry<Key, Comparable>> values) {
                Comparable min = null;
                for (Map.Entry entry : values) {
                    Comparable value = entry.getValue();
                    if (min != null && value.compareTo(min) >= 0) continue;
                    min = value;
                }
                return min;
            }
        };
    }

    @Override
    public Mapper<Key, Value, Key, Comparable> getMapper(Supplier<Key, Value, Comparable> supplier) {
        return new SupplierConsumingMapper<Key, Value, Comparable>(supplier);
    }

    @Override
    public CombinerFactory<Key, Comparable, Comparable> getCombinerFactory() {
        return new ComparableMinCombinerFactory();
    }

    @Override
    public ReducerFactory<Key, Comparable, Comparable> getReducerFactory() {
        return new ComparableMinReducerFactory();
    }

    @BinaryInterface
    static final class ComparableMinCombinerFactory<Key>
    extends AbstractAggregationCombinerFactory<Key, Comparable, Comparable> {
        ComparableMinCombinerFactory() {
        }

        @Override
        public Combiner<Comparable, Comparable> newCombiner(Key key) {
            return new ComparableMinCombiner();
        }

        @Override
        public int getId() {
            return 22;
        }
    }

    @BinaryInterface
    static final class ComparableMinReducerFactory<Key>
    extends AbstractAggregationReducerFactory<Key, Comparable, Comparable> {
        ComparableMinReducerFactory() {
        }

        @Override
        public Reducer<Comparable, Comparable> newReducer(Key key) {
            return new ComparableMinReducer();
        }

        @Override
        public int getId() {
            return 23;
        }
    }

    private static final class ComparableMinReducer
    extends Reducer<Comparable, Comparable> {
        private Comparable min;

        private ComparableMinReducer() {
        }

        @Override
        public void reduce(Comparable value) {
            if (this.min == null || value.compareTo(this.min) < 0) {
                this.min = value;
            }
        }

        @Override
        public Comparable finalizeReduce() {
            return this.min;
        }
    }

    private static final class ComparableMinCombiner
    extends Combiner<Comparable, Comparable> {
        private Comparable min;

        private ComparableMinCombiner() {
        }

        @Override
        public void combine(Comparable value) {
            if (this.min == null || value.compareTo(this.min) < 0) {
                this.min = value;
            }
        }

        @Override
        public Comparable finalizeChunk() {
            Comparable value = this.min;
            this.min = null;
            return value;
        }
    }
}

