/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.mapreduce.impl;

import com.atlassian.nutcluster.config.JobTrackerConfig;
import com.atlassian.nutcluster.internal.util.RuntimeAvailableProcessors;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.mapreduce.Job;
import com.atlassian.nutcluster.mapreduce.KeyValueSource;
import com.atlassian.nutcluster.mapreduce.impl.AbstractJobTracker;
import com.atlassian.nutcluster.mapreduce.impl.MapReduceService;
import com.atlassian.nutcluster.mapreduce.impl.MapReduceUtil;
import com.atlassian.nutcluster.mapreduce.impl.task.KeyValueJob;
import com.atlassian.nutcluster.spi.ExecutionService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.partition.IPartitionService;
import com.atlassian.nutcluster.util.executor.ExecutorType;
import java.util.concurrent.CopyOnWriteArrayList;

class NodeJobTracker
extends AbstractJobTracker {
    private final CopyOnWriteArrayList<String> cancelledJobs = new CopyOnWriteArrayList();

    NodeJobTracker(String name, JobTrackerConfig jobTrackerConfig, NodeEngine nodeEngine, MapReduceService mapReduceService) {
        super(name, jobTrackerConfig, nodeEngine, mapReduceService);
        int queueSize;
        ExecutionService es = nodeEngine.getExecutionService();
        IPartitionService ps = nodeEngine.getPartitionService();
        int maxThreadSize = jobTrackerConfig.getMaxThreadSize();
        if (maxThreadSize <= 0) {
            maxThreadSize = RuntimeAvailableProcessors.get();
        }
        if ((queueSize = jobTrackerConfig.getQueueSize()) <= 0) {
            queueSize = ps.getPartitionCount() * 2;
        }
        try {
            String executorName = MapReduceUtil.buildExecutorName(name);
            es.register(executorName, maxThreadSize, queueSize, ExecutorType.CACHED);
        }
        catch (Exception ignore) {
            ILogger logger = nodeEngine.getLogger(NodeJobTracker.class);
            logger.finest("This is likely happened due to a previously cancelled job", ignore);
        }
    }

    @Override
    public <K, V> Job<K, V> newJob(KeyValueSource<K, V> source) {
        return new KeyValueJob<K, V>(this.name, this, this.nodeEngine, this.mapReduceService, source);
    }

    public boolean registerJobSupervisorCancellation(String jobId) {
        return this.cancelledJobs.addIfAbsent(jobId);
    }

    public boolean unregisterJobSupervisorCancellation(String jobId) {
        return this.cancelledJobs.remove(jobId);
    }
}

