/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.multimap.impl;

import com.atlassian.nutcluster.core.EntryEventType;
import com.atlassian.nutcluster.map.impl.event.EntryEventData;
import com.atlassian.nutcluster.map.impl.event.MapEventData;
import com.atlassian.nutcluster.multimap.impl.MultiMapEventFilter;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.EventRegistration;
import com.atlassian.nutcluster.spi.EventService;
import com.atlassian.nutcluster.spi.NodeEngine;
import java.util.Collection;

public class MultiMapEventsPublisher {
    private final NodeEngine nodeEngine;

    public MultiMapEventsPublisher(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public void publishMultiMapEvent(String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:multiMapService", mapName);
        if (registrations.isEmpty()) {
            return;
        }
        Address caller = this.nodeEngine.getThisAddress();
        String source = caller.toString();
        MapEventData mapEventData = new MapEventData(source, mapName, caller, eventType.getType(), numberOfEntriesAffected);
        eventService.publishEvent("hz:impl:multiMapService", registrations, (Object)mapEventData, mapName.hashCode());
    }

    public final void publishEntryEvent(String multiMapName, EntryEventType eventType, Data key, Object newValue, Object oldValue) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:multiMapService", multiMapName);
        for (EventRegistration registration : registrations) {
            MultiMapEventFilter filter = (MultiMapEventFilter)registration.getFilter();
            if (filter.getKey() != null && !filter.getKey().equals(key)) continue;
            Data dataNewValue = filter.isIncludeValue() ? this.nodeEngine.toData(newValue) : null;
            Data dataOldValue = filter.isIncludeValue() ? this.nodeEngine.toData(oldValue) : null;
            Address caller = this.nodeEngine.getThisAddress();
            String source = caller.toString();
            EntryEventData event = new EntryEventData(source, multiMapName, caller, key, dataNewValue, dataOldValue, eventType.getType());
            eventService.publishEvent("hz:impl:multiMapService", registration, (Object)event, multiMapName.hashCode());
        }
    }
}

