/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.multimap.impl.operations;

import com.atlassian.nutcluster.multimap.impl.MultiMapContainer;
import com.atlassian.nutcluster.multimap.impl.MultiMapService;
import com.atlassian.nutcluster.multimap.impl.operations.AbstractMultiMapOperation;
import com.atlassian.nutcluster.multimap.impl.operations.ClearBackupOperation;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;

public class ClearOperation
extends AbstractMultiMapOperation
implements BackupAwareOperation,
PartitionAwareOperation,
MutatingOperation {
    private transient MultiMapContainer container;
    private transient boolean shouldBackup;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void beforeRun() throws Exception {
        this.container = this.getOrCreateContainer();
        this.shouldBackup = this.container.size() > 0;
    }

    @Override
    public void run() throws Exception {
        this.container = this.getOrCreateContainer();
        this.response = this.container.clear();
    }

    @Override
    public void afterRun() throws Exception {
        ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
        if (this.shouldBackup) {
            this.container.update();
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearBackupOperation(this.name);
    }

    @Override
    public int getId() {
        return 3;
    }
}

