/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.multimap.impl.txn;

import com.atlassian.nutcluster.multimap.impl.MultiMapContainer;
import com.atlassian.nutcluster.multimap.impl.operations.AbstractKeyBasedMultiMapOperation;
import com.atlassian.nutcluster.multimap.impl.txn.TxnPrepareOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.impl.Versioned;
import com.atlassian.nutcluster.spi.BackupOperation;
import com.atlassian.nutcluster.transaction.TransactionException;
import java.io.IOException;

public class TxnPrepareBackupOperation
extends AbstractKeyBasedMultiMapOperation
implements BackupOperation,
Versioned {
    private String caller;

    public TxnPrepareBackupOperation() {
    }

    public TxnPrepareBackupOperation(String name, Data dataKey, long threadId, String caller) {
        super(name, dataKey, threadId);
        this.caller = caller;
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainerWithoutAccess();
        if (!container.txnLock(this.dataKey, this.caller, this.threadId, this.getCallId(), TxnPrepareOperation.LOCK_EXTENSION_TIME_IN_MILLIS, true)) {
            throw new TransactionException("Lock is not owned by the transaction! -> " + container.getLockOwnerInfo(this.dataKey));
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.caller);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.caller = in.readUTF();
    }

    @Override
    public int getId() {
        return 31;
    }
}

