/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.ascii;

import com.atlassian.nutcluster.internal.ascii.CommandParser;
import com.atlassian.nutcluster.internal.ascii.TextCommandConstants;
import com.atlassian.nutcluster.internal.ascii.memcache.DeleteCommandParser;
import com.atlassian.nutcluster.internal.ascii.memcache.GetCommandParser;
import com.atlassian.nutcluster.internal.ascii.memcache.IncrementCommandParser;
import com.atlassian.nutcluster.internal.ascii.memcache.SetCommandParser;
import com.atlassian.nutcluster.internal.ascii.memcache.SimpleCommandParser;
import com.atlassian.nutcluster.internal.ascii.memcache.TouchCommandParser;
import com.atlassian.nutcluster.nio.ascii.AllowingTextProtocolFilter;
import com.atlassian.nutcluster.nio.ascii.TextDecoder;
import com.atlassian.nutcluster.nio.ascii.TextEncoder;
import com.atlassian.nutcluster.nio.ascii.TextParsers;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import java.util.HashMap;

@PrivateApi
public class MemcacheTextDecoder
extends TextDecoder {
    public static final TextParsers TEXT_PARSERS;

    public MemcacheTextDecoder(TcpIpConnection connection, TextEncoder encoder, boolean rootDecoder) {
        super(connection, encoder, AllowingTextProtocolFilter.INSTANCE, TEXT_PARSERS, rootDecoder);
    }

    static {
        HashMap<String, CommandParser> parsers = new HashMap<String, CommandParser>();
        parsers.put("get", new GetCommandParser());
        parsers.put("gets", new GetCommandParser());
        parsers.put("set", new SetCommandParser(TextCommandConstants.TextCommandType.SET));
        parsers.put("add", new SetCommandParser(TextCommandConstants.TextCommandType.ADD));
        parsers.put("replace", new SetCommandParser(TextCommandConstants.TextCommandType.REPLACE));
        parsers.put("append", new SetCommandParser(TextCommandConstants.TextCommandType.APPEND));
        parsers.put("prepend", new SetCommandParser(TextCommandConstants.TextCommandType.PREPEND));
        parsers.put("touch", new TouchCommandParser(TextCommandConstants.TextCommandType.TOUCH));
        parsers.put("incr", new IncrementCommandParser(TextCommandConstants.TextCommandType.INCREMENT));
        parsers.put("decr", new IncrementCommandParser(TextCommandConstants.TextCommandType.DECREMENT));
        parsers.put("delete", new DeleteCommandParser());
        parsers.put("quit", new SimpleCommandParser(TextCommandConstants.TextCommandType.QUIT));
        parsers.put("stats", new SimpleCommandParser(TextCommandConstants.TextCommandType.STATS));
        parsers.put("version", new SimpleCommandParser(TextCommandConstants.TextCommandType.VERSION));
        TEXT_PARSERS = new TextParsers(parsers);
    }
}

