/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.ascii;

import com.atlassian.nutcluster.config.EndpointConfig;
import com.atlassian.nutcluster.instance.ProtocolType;
import com.atlassian.nutcluster.internal.networking.Channel;
import com.atlassian.nutcluster.nio.IOService;
import com.atlassian.nutcluster.nio.ascii.MemcacheTextDecoder;
import com.atlassian.nutcluster.nio.ascii.RestApiTextDecoder;
import com.atlassian.nutcluster.nio.ascii.TextDecoder;
import com.atlassian.nutcluster.nio.ascii.TextEncoder;
import com.atlassian.nutcluster.nio.tcp.AbstractChannelInitializer;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.nio.tcp.TextHandshakeDecoder;

public class TextChannelInitializer
extends AbstractChannelInitializer {
    private final boolean rest;

    public TextChannelInitializer(IOService ioService, EndpointConfig config, boolean rest) {
        super(ioService, config);
        this.rest = rest;
    }

    @Override
    public void initChannel(Channel channel) {
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        TextEncoder encoder = new TextEncoder(connection);
        TextDecoder decoder = this.rest ? new RestApiTextDecoder(connection, encoder, true) : new MemcacheTextDecoder(connection, encoder, true);
        TextHandshakeDecoder handshaker = new TextHandshakeDecoder(this.rest ? ProtocolType.REST : ProtocolType.MEMCACHE, decoder);
        channel.outboundPipeline().addLast(encoder);
        channel.inboundPipeline().addLast(handshaker);
    }
}

