/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.tcp;

import com.atlassian.nutcluster.config.EndpointConfig;
import com.atlassian.nutcluster.instance.EndpointQualifier;
import com.atlassian.nutcluster.instance.ProtocolType;
import com.atlassian.nutcluster.internal.networking.Channel;
import com.atlassian.nutcluster.internal.networking.InboundHandler;
import com.atlassian.nutcluster.internal.networking.OutboundHandler;
import com.atlassian.nutcluster.nio.IOService;
import com.atlassian.nutcluster.nio.tcp.AbstractChannelInitializer;
import com.atlassian.nutcluster.nio.tcp.MemberProtocolEncoder;
import com.atlassian.nutcluster.nio.tcp.SingleProtocolDecoder;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;

public class MemberChannelInitializer
extends AbstractChannelInitializer {
    MemberChannelInitializer(IOService ioService, EndpointConfig config) {
        super(ioService, config);
    }

    @Override
    public void initChannel(Channel channel) {
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        OutboundHandler[] outboundHandlers = this.ioService.createOutboundHandlers(EndpointQualifier.MEMBER, connection);
        InboundHandler[] inboundHandlers = this.ioService.createInboundHandlers(EndpointQualifier.MEMBER, connection);
        MemberProtocolEncoder protocolEncoder = new MemberProtocolEncoder(outboundHandlers);
        SingleProtocolDecoder protocolDecoder = new SingleProtocolDecoder(ProtocolType.MEMBER, inboundHandlers, protocolEncoder);
        channel.outboundPipeline().addLast(protocolEncoder);
        channel.inboundPipeline().addLast(protocolDecoder);
    }
}

