/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.nio.tcp;

import com.atlassian.nutcluster.config.EndpointConfig;
import com.atlassian.nutcluster.instance.ProtocolType;
import com.atlassian.nutcluster.internal.metrics.MetricsRegistry;
import com.atlassian.nutcluster.internal.metrics.Probe;
import com.atlassian.nutcluster.internal.metrics.ProbeLevel;
import com.atlassian.nutcluster.internal.networking.ChannelInitializerProvider;
import com.atlassian.nutcluster.logging.LoggingService;
import com.atlassian.nutcluster.nio.ConnectionType;
import com.atlassian.nutcluster.nio.IOService;
import com.atlassian.nutcluster.nio.NetworkingService;
import com.atlassian.nutcluster.nio.tcp.TcpIpConnection;
import com.atlassian.nutcluster.nio.tcp.TcpIpEndpointManager;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class TcpIpUnifiedEndpointManager
extends TcpIpEndpointManager {
    TcpIpUnifiedEndpointManager(NetworkingService root, EndpointConfig endpointConfig, ChannelInitializerProvider channelInitializerProvider, IOService ioService, LoggingService loggingService, MetricsRegistry metricsRegistry, NutclusterProperties properties) {
        super(root, endpointConfig, channelInitializerProvider, ioService, loggingService, metricsRegistry, properties, ProtocolType.valuesAsSet());
    }

    Set<TcpIpConnection> getRestConnections() {
        HashSet<TcpIpConnection> connections = this.activeConnections.isEmpty() ? Collections.emptySet() : new HashSet<TcpIpConnection>(this.activeConnections.size());
        for (TcpIpConnection conn : this.activeConnections) {
            if (!conn.isAlive() || conn.getType() != ConnectionType.REST_CLIENT) continue;
            connections.add(conn);
        }
        return connections;
    }

    Set<TcpIpConnection> getMemachedConnections() {
        HashSet<TcpIpConnection> connections = this.activeConnections.isEmpty() ? Collections.emptySet() : new HashSet<TcpIpConnection>(this.activeConnections.size());
        for (TcpIpConnection conn : this.activeConnections) {
            if (!conn.isAlive() || conn.getType() != ConnectionType.MEMCACHE_CLIENT) continue;
            connections.add(conn);
        }
        return connections;
    }

    Set<TcpIpConnection> getTextConnections() {
        HashSet<TcpIpConnection> connections = this.activeConnections.isEmpty() ? Collections.emptySet() : new HashSet<TcpIpConnection>(this.activeConnections.size());
        for (TcpIpConnection conn : this.activeConnections) {
            if ((!conn.isAlive() || conn.getType() != ConnectionType.REST_CLIENT) && conn.getType() != ConnectionType.MEMCACHE_CLIENT) continue;
            connections.add(conn);
        }
        return connections;
    }

    Set<TcpIpConnection> getCurrentClientConnections() {
        HashSet<TcpIpConnection> connections = this.activeConnections.isEmpty() ? Collections.emptySet() : new HashSet<TcpIpConnection>(this.activeConnections.size());
        for (TcpIpConnection conn : this.activeConnections) {
            if (!conn.isAlive() || !conn.isClient()) continue;
            connections.add(conn);
        }
        return connections;
    }

    @Probe(name="clientCount", level=ProbeLevel.MANDATORY)
    public int getCurrentClientConnectionsCount() {
        return this.getCurrentClientConnections().size();
    }

    @Probe(name="textCount", level=ProbeLevel.MANDATORY)
    public int getCurrentTextConnections() {
        return this.getTextConnections().size();
    }
}

