/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.osgi.impl;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.GroupConfig;
import com.atlassian.nutcluster.config.XmlConfigBuilder;
import com.atlassian.nutcluster.core.Nutcluster;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.osgi.NutclusterOSGiInstance;
import com.atlassian.nutcluster.osgi.NutclusterOSGiService;
import com.atlassian.nutcluster.osgi.impl.NutclusterInternalOSGiService;
import com.atlassian.nutcluster.osgi.impl.NutclusterOSGiInstanceImpl;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class NutclusterOSGiServiceImpl
implements NutclusterInternalOSGiService {
    private static final ILogger LOGGER = Logger.getLogger(NutclusterOSGiService.class);
    private final Object serviceMutex = new Object();
    private final Bundle ownerBundle;
    private final BundleContext ownerBundleContext;
    private final String id;
    private final ConcurrentMap<NutclusterOSGiInstance, ServiceRegistration> instanceServiceRegistrationMap = new ConcurrentHashMap<NutclusterOSGiInstance, ServiceRegistration>();
    private final ConcurrentMap<String, NutclusterOSGiInstance> instanceMap = new ConcurrentHashMap<String, NutclusterOSGiInstance>();
    private ServiceRegistration serviceRegistration;
    private volatile NutclusterOSGiInstance NutclusterInstance;

    public NutclusterOSGiServiceImpl(Bundle ownerBundle) {
        this(ownerBundle, DEFAULT_ID);
    }

    public NutclusterOSGiServiceImpl(Bundle ownerBundle, String id) {
        this.ownerBundle = ownerBundle;
        this.ownerBundleContext = ownerBundle.getBundleContext();
        this.id = id;
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("Nutcluster OSGI Service is not active!");
        }
    }

    private boolean shouldSetGroupName(GroupConfig groupConfig) {
        return (groupConfig == null || StringUtil.isNullOrEmpty(groupConfig.getName()) || "dev".equals(groupConfig.getName())) && !Boolean.getBoolean("hazelcast.osgi.grouping.disabled");
    }

    private Config getConfig(Config config) {
        GroupConfig groupConfig;
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if (this.shouldSetGroupName(groupConfig = config.getGroupConfig())) {
            String groupName = this.id;
            if (groupConfig == null) {
                config.setGroupConfig(new GroupConfig(groupName));
            } else {
                groupConfig.setName(groupName);
            }
        }
        return config;
    }

    private NutclusterInstance createNutclusterInstance(Config config) {
        return Nutcluster.newNutclusterInstance(this.getConfig(config));
    }

    private NutclusterOSGiInstance registerInstance(NutclusterInstance instance) {
        NutclusterOSGiInstance nutclusterOSGiInstance = instance instanceof NutclusterOSGiInstance ? (NutclusterOSGiInstance)instance : new NutclusterOSGiInstanceImpl(instance, this);
        if (!Boolean.getBoolean("hazelcast.osgi.register.disabled")) {
            ServiceRegistration serviceRegistration = this.ownerBundleContext.registerService(NutclusterInstance.class.getName(), (Object)nutclusterOSGiInstance, null);
            this.instanceServiceRegistrationMap.put(nutclusterOSGiInstance, serviceRegistration);
        }
        this.instanceMap.put(instance.getName(), nutclusterOSGiInstance);
        return nutclusterOSGiInstance;
    }

    private void deregisterInstance(NutclusterOSGiInstance nutclusterOSGiInstance) {
        this.instanceMap.remove(nutclusterOSGiInstance.getName());
        ServiceRegistration serviceRegistration = (ServiceRegistration)this.instanceServiceRegistrationMap.remove(nutclusterOSGiInstance);
        if (serviceRegistration != null) {
            this.ownerBundleContext.ungetService(serviceRegistration.getReference());
            serviceRegistration.unregister();
        }
    }

    private void shutdownDefaultNutclusterInstanceIfActive() {
        if (this.NutclusterInstance != null) {
            this.shutdownNutclusterInstanceInternalSafely(this.NutclusterInstance);
            this.NutclusterInstance = null;
        }
    }

    private void shutdownAllInternal() {
        for (NutclusterOSGiInstance instance : this.instanceMap.values()) {
            this.shutdownNutclusterInstanceInternalSafely(instance);
        }
        this.shutdownDefaultNutclusterInstanceIfActive();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Bundle getOwnerBundle() {
        return this.ownerBundle;
    }

    @Override
    public boolean isActive() {
        return this.ownerBundle.getState() == 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        Object object = this.serviceMutex;
        synchronized (object) {
            if (this.ownerBundle.getState() == 8) {
                try {
                    if (this.NutclusterInstance != null) {
                        LOGGER.warning("Default Nutcluster instance should be null while activating service!");
                        this.shutdownDefaultNutclusterInstanceIfActive();
                    }
                    if (Boolean.getBoolean("hazelcast.osgi.start")) {
                        this.NutclusterInstance = new NutclusterOSGiInstanceImpl(this.createNutclusterInstance(null), this);
                        LOGGER.info("Default Nutcluster instance has been created");
                    }
                    if (this.NutclusterInstance != null && !Boolean.getBoolean("hazelcast.osgi.register.disabled")) {
                        this.registerInstance(this.NutclusterInstance);
                        LOGGER.info("Default Nutcluster instance has been registered as OSGI service");
                    }
                    this.serviceRegistration = this.ownerBundleContext.registerService(NutclusterOSGiService.class.getName(), (Object)this, null);
                    LOGGER.info(String.valueOf(this) + " has been registered as OSGI service and activated now");
                }
                catch (Throwable t) {
                    this.shutdownDefaultNutclusterInstanceIfActive();
                    ExceptionUtil.rethrow(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Object object = this.serviceMutex;
        synchronized (object) {
            if (this.ownerBundle.getState() == 16) {
                try {
                    this.shutdownAllInternal();
                    try {
                        this.ownerBundleContext.ungetService(this.serviceRegistration.getReference());
                        this.serviceRegistration.unregister();
                    }
                    catch (Throwable t) {
                        LOGGER.finest("Error occurred while deregistering " + String.valueOf(this), t);
                    }
                    LOGGER.info(String.valueOf(this) + " has been deregistered as OSGI service and deactivated");
                }
                finally {
                    this.serviceRegistration = null;
                }
            }
        }
    }

    @Override
    public NutclusterOSGiInstance getDefaultNutclusterInstance() {
        this.checkActive();
        return this.NutclusterInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NutclusterOSGiInstance newNutclusterInstance(Config config) {
        Object object = this.serviceMutex;
        synchronized (object) {
            this.checkActive();
            return this.registerInstance(this.createNutclusterInstance(config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NutclusterOSGiInstance newNutclusterInstance() {
        Object object = this.serviceMutex;
        synchronized (object) {
            this.checkActive();
            return this.registerInstance(this.createNutclusterInstance(null));
        }
    }

    @Override
    public NutclusterOSGiInstance getNutclusterInstanceByName(String instanceName) {
        this.checkActive();
        return (NutclusterOSGiInstance)this.instanceMap.get(instanceName);
    }

    @Override
    public Set<NutclusterOSGiInstance> getAllNutclusterInstances() {
        this.checkActive();
        return new HashSet<NutclusterOSGiInstance>(this.instanceMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNutclusterInstance(NutclusterOSGiInstance instance) {
        Object object = this.serviceMutex;
        synchronized (object) {
            this.checkActive();
            this.shutdownNutclusterInstanceInternal(instance);
        }
    }

    private void shutdownNutclusterInstanceInternal(NutclusterOSGiInstance instance) {
        try {
            this.deregisterInstance(instance);
        }
        catch (Throwable t) {
            LOGGER.finest("Error occurred while deregistering " + String.valueOf(instance), t);
        }
        instance.shutdown();
    }

    private void shutdownNutclusterInstanceInternalSafely(NutclusterOSGiInstance instance) {
        try {
            this.shutdownNutclusterInstanceInternal(instance);
        }
        catch (Throwable t) {
            LOGGER.finest("Error occurred while shutting down " + String.valueOf(instance), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownAll() {
        Object object = this.serviceMutex;
        synchronized (object) {
            this.checkActive();
            this.shutdownAllInternal();
        }
    }

    public String toString() {
        return "NutclusterOSGiServiceImpl{ownerBundle=" + String.valueOf(this.ownerBundle) + ", NutclusterInstance=" + String.valueOf(this.NutclusterInstance) + ", active=" + this.isActive() + ", id=" + this.id + "}";
    }
}

