/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.partition;

import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.DataSerializable;
import com.atlassian.nutcluster.nio.serialization.SerializableByConvention;
import com.atlassian.nutcluster.partition.PartitionEvent;
import java.io.IOException;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class PartitionLostEvent
implements DataSerializable,
PartitionEvent {
    private int partitionId;
    private int lostBackupCount;
    private Address eventSource;

    public PartitionLostEvent() {
    }

    public PartitionLostEvent(int partitionId, int lostBackupCount, Address eventSource) {
        this.partitionId = partitionId;
        this.lostBackupCount = lostBackupCount;
        this.eventSource = eventSource;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    public int getLostBackupCount() {
        return this.lostBackupCount;
    }

    public Address getEventSource() {
        return this.eventSource;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        out.writeInt(this.lostBackupCount);
        out.writeObject(this.eventSource);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionId = in.readInt();
        this.lostBackupCount = in.readInt();
        this.eventSource = (Address)in.readObject();
    }

    public String toString() {
        return this.getClass().getName() + "{partitionId=" + this.partitionId + ", lostBackupCount=" + this.lostBackupCount + ", eventSource=" + String.valueOf(this.eventSource) + "}";
    }
}

