/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.partition.membergroup;

import com.atlassian.nutcluster.config.InvalidConfigurationException;
import com.atlassian.nutcluster.config.properties.ValidationException;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.partition.membergroup.BackupSafeMemberGroupFactory;
import com.atlassian.nutcluster.partition.membergroup.MemberGroup;
import com.atlassian.nutcluster.partition.membergroup.MemberGroupFactory;
import com.atlassian.nutcluster.spi.discovery.DiscoveryStrategy;
import com.atlassian.nutcluster.spi.discovery.impl.DefaultDiscoveryService;
import com.atlassian.nutcluster.spi.discovery.integration.DiscoveryService;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.SetUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SPIAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    private final DiscoveryService discoveryService;

    public SPIAwareMemberGroupFactory(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        Set<MemberGroup> memberGroups = SetUtil.createHashSet(allMembers.size());
        for (Member member : allMembers) {
            try {
                if (!member.localMember()) continue;
                DefaultDiscoveryService defaultDiscoveryService = (DefaultDiscoveryService)this.discoveryService;
                if (!defaultDiscoveryService.getDiscoveryStrategies().iterator().hasNext()) {
                    throw new RuntimeException("Could not load any Discovery Strategy, please check service definitions under META_INF.services folder. ");
                }
                Iterator<DiscoveryStrategy> iterator = defaultDiscoveryService.getDiscoveryStrategies().iterator();
                if (!iterator.hasNext()) continue;
                DiscoveryStrategy discoveryStrategy = iterator.next();
                Preconditions.checkNotNull(discoveryStrategy.getPartitionGroupStrategy());
                Iterable<MemberGroup> spiGroupsIterator = discoveryStrategy.getPartitionGroupStrategy().getMemberGroups();
                for (MemberGroup group : spiGroupsIterator) {
                    memberGroups.add(group);
                }
                return memberGroups;
            }
            catch (Exception e) {
                if (e instanceof ValidationException) {
                    throw new InvalidConfigurationException("Invalid configuration", e);
                }
                throw new RuntimeException("Failed to configure discovery strategies", e);
            }
        }
        return memberGroups;
    }
}

