/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.projection.impl;

import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.projection.Projection;
import com.atlassian.nutcluster.projection.impl.ProjectionDataSerializerHook;
import com.atlassian.nutcluster.query.impl.Extractable;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.IOException;

public final class MultiAttributeProjection<I>
extends Projection<I, Object[]>
implements IdentifiedDataSerializable {
    private String[] attributePaths;

    MultiAttributeProjection() {
    }

    public MultiAttributeProjection(String ... attributePath) {
        if (attributePath == null || attributePath.length == 0) {
            throw new IllegalArgumentException("You need to specify at least one attributePath");
        }
        for (String path : attributePath) {
            Preconditions.checkHasText(path, "attributePath must not be null or empty");
            Preconditions.checkFalse(path.contains("[any]"), "attributePath must not contain [any] operators");
        }
        this.attributePaths = attributePath;
    }

    @Override
    public Object[] transform(I input) {
        if (input instanceof Extractable) {
            Extractable extractable = (Extractable)input;
            Object[] result = new Object[this.attributePaths.length];
            for (int i = 0; i < this.attributePaths.length; ++i) {
                result[i] = extractable.getAttributeValue(this.attributePaths[i]);
            }
            return result;
        }
        throw new IllegalArgumentException("The given map entry is not extractable");
    }

    @Override
    public int getFactoryId() {
        return ProjectionDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTFArray(this.attributePaths);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributePaths = in.readUTFArray();
    }
}

