/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.query.impl.getters;

import com.atlassian.nutcluster.core.NutclusterJsonValue;
import com.atlassian.nutcluster.internal.serialization.impl.NavigableJsonInputAdapter;
import com.atlassian.nutcluster.internal.serialization.impl.StringNavigableJsonAdapter;
import com.atlassian.nutcluster.query.QueryException;
import com.atlassian.nutcluster.query.impl.getters.AbstractJsonGetter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;

public final class JsonGetter
extends AbstractJsonGetter {
    public static final JsonGetter INSTANCE = new JsonGetter();
    private JsonFactory factory = new JsonFactory();

    protected JsonGetter() {
        super(null);
    }

    @Override
    protected NavigableJsonInputAdapter annotate(Object object) {
        NutclusterJsonValue hazelcastJson = (NutclusterJsonValue)object;
        return new StringNavigableJsonAdapter(hazelcastJson.toString(), 0);
    }

    @Override
    JsonParser createParser(Object obj) throws IOException {
        if (obj instanceof NutclusterJsonValue) {
            return this.factory.createParser(obj.toString());
        }
        throw new QueryException("Queried object is not of NutclusterJsonValue type. It is " + String.valueOf(obj.getClass()));
    }
}

