/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.query.impl.predicates;

import com.atlassian.nutcluster.query.impl.predicates.EmptyOptimizer;
import com.atlassian.nutcluster.query.impl.predicates.QueryOptimizer;
import com.atlassian.nutcluster.query.impl.predicates.RuleBasedQueryOptimizer;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import com.atlassian.nutcluster.spi.properties.NutclusterProperty;
import java.util.Arrays;

public final class QueryOptimizerFactory {
    private QueryOptimizerFactory() {
    }

    public static QueryOptimizer newOptimizer(NutclusterProperties properties) {
        Type type;
        NutclusterProperty property = GroupProperty.QUERY_OPTIMIZER_TYPE;
        String string = properties.getString(property);
        try {
            type = Type.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            throw QueryOptimizerFactory.onInvalidOptimizerType(string);
        }
        switch (type.ordinal()) {
            case 1: {
                return new RuleBasedQueryOptimizer();
            }
        }
        return new EmptyOptimizer();
    }

    private static IllegalArgumentException onInvalidOptimizerType(String type) {
        StringBuilder sb = new StringBuilder("Unknown Optimizer Type: ").append(type).append(". Use property '").append(GroupProperty.QUERY_OPTIMIZER_TYPE.getName()).append("' to select optimizer. ").append("Available optimizers: ");
        Type[] values = Type.values();
        sb.append(Arrays.toString((Object[])values));
        return new IllegalArgumentException(sb.toString());
    }

    public static enum Type {
        NONE,
        RULES;

    }
}

