/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.query.impl.predicates;

import com.atlassian.nutcluster.query.Predicate;
import com.atlassian.nutcluster.query.VisitablePredicate;
import com.atlassian.nutcluster.query.impl.Indexes;
import com.atlassian.nutcluster.query.impl.predicates.CompositeIndexVisitor;
import com.atlassian.nutcluster.query.impl.predicates.EvaluateVisitor;
import com.atlassian.nutcluster.query.impl.predicates.FlatteningVisitor;
import com.atlassian.nutcluster.query.impl.predicates.OrToInVisitor;
import com.atlassian.nutcluster.query.impl.predicates.QueryOptimizer;
import com.atlassian.nutcluster.query.impl.predicates.RangeVisitor;
import com.atlassian.nutcluster.query.impl.predicates.Visitor;

public final class RuleBasedQueryOptimizer
implements QueryOptimizer {
    private final Visitor flatteningVisitor = new FlatteningVisitor();
    private final Visitor rangeVisitor = new RangeVisitor();
    private final Visitor orToInVisitor = new OrToInVisitor();
    private final Visitor compositeIndexVisitor = new CompositeIndexVisitor();
    private final Visitor evaluateVisitor = new EvaluateVisitor();

    @Override
    public <K, V> Predicate<K, V> optimize(Predicate<K, V> predicate, Indexes indexes) {
        Predicate optimized = predicate;
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.flatteningVisitor, indexes);
        }
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.rangeVisitor, indexes);
        }
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.orToInVisitor, indexes);
        }
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.compositeIndexVisitor, indexes);
        }
        if (optimized instanceof VisitablePredicate) {
            optimized = ((VisitablePredicate)((Object)optimized)).accept(this.evaluateVisitor, indexes);
        }
        return optimized;
    }
}

