/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.quorum.impl;

import com.atlassian.nutcluster.config.QuorumConfig;
import com.atlassian.nutcluster.core.ManagedContext;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.quorum.HeartbeatAware;
import com.atlassian.nutcluster.quorum.PingAware;
import com.atlassian.nutcluster.quorum.Quorum;
import com.atlassian.nutcluster.quorum.QuorumEvent;
import com.atlassian.nutcluster.quorum.QuorumException;
import com.atlassian.nutcluster.quorum.QuorumFunction;
import com.atlassian.nutcluster.quorum.QuorumService;
import com.atlassian.nutcluster.quorum.QuorumType;
import com.atlassian.nutcluster.quorum.impl.MemberCountQuorumFunction;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.ReadonlyOperation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.spi.impl.QuorumCheckAwareOperation;
import com.atlassian.nutcluster.spi.impl.eventservice.InternalEventService;
import com.atlassian.nutcluster.util.ExceptionUtil;
import java.util.Collection;

public class QuorumImpl
implements Quorum {
    private final NodeEngineImpl nodeEngine;
    private final String quorumName;
    private final int size;
    private final QuorumConfig config;
    private final InternalEventService eventService;
    private final QuorumFunction quorumFunction;
    private final boolean heartbeatAwareQuorumFunction;
    private final boolean pingAwareQuorumFunction;
    private final boolean membershipListenerQuorumFunction;
    private volatile QuorumState quorumState = QuorumState.INITIAL;

    QuorumImpl(QuorumConfig config, NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.eventService = nodeEngine.getEventService();
        this.config = config;
        this.quorumName = config.getName();
        this.size = config.getSize();
        this.quorumFunction = this.initializeQuorumFunction();
        this.heartbeatAwareQuorumFunction = this.quorumFunction instanceof HeartbeatAware;
        this.membershipListenerQuorumFunction = this.quorumFunction instanceof MembershipListener;
        this.pingAwareQuorumFunction = this.quorumFunction instanceof PingAware;
    }

    void update(Collection<Member> members) {
        QuorumState previousQuorumState = this.quorumState;
        QuorumState newQuorumState = QuorumState.ABSENT;
        try {
            boolean present = this.quorumFunction.apply(members);
            newQuorumState = present ? QuorumState.PRESENT : QuorumState.ABSENT;
        }
        catch (Exception e) {
            ILogger logger = this.nodeEngine.getLogger(QuorumService.class);
            logger.severe("Quorum function of quorum: " + this.quorumName + " failed! Quorum status is set to " + String.valueOf((Object)newQuorumState), e);
        }
        if (previousQuorumState == QuorumState.INITIAL && newQuorumState != QuorumState.PRESENT) {
            return;
        }
        this.quorumState = newQuorumState;
        if (previousQuorumState == QuorumState.INITIAL) {
            return;
        }
        if (previousQuorumState != newQuorumState) {
            this.createAndPublishEvent(members, newQuorumState == QuorumState.PRESENT);
        }
    }

    void onHeartbeat(Member member, long timestamp) {
        if (!this.heartbeatAwareQuorumFunction) {
            return;
        }
        ((HeartbeatAware)((Object)this.quorumFunction)).onHeartbeat(member, timestamp);
    }

    void onPing(Member member, boolean successful) {
        if (!this.pingAwareQuorumFunction) {
            return;
        }
        PingAware pingAware = (PingAware)((Object)this.quorumFunction);
        if (successful) {
            pingAware.onPingRestored(member);
        } else {
            pingAware.onPingLost(member);
        }
    }

    void onMemberAdded(MembershipEvent event) {
        if (!this.membershipListenerQuorumFunction) {
            return;
        }
        ((MembershipListener)((Object)this.quorumFunction)).memberAdded(event);
    }

    void onMemberRemoved(MembershipEvent event) {
        if (!this.membershipListenerQuorumFunction) {
            return;
        }
        ((MembershipListener)((Object)this.quorumFunction)).memberRemoved(event);
    }

    public String getName() {
        return this.quorumName;
    }

    public int getSize() {
        return this.size;
    }

    public QuorumConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isPresent() {
        return this.quorumState == QuorumState.PRESENT;
    }

    boolean isHeartbeatAware() {
        return this.heartbeatAwareQuorumFunction;
    }

    boolean isPingAware() {
        return this.pingAwareQuorumFunction;
    }

    private boolean isQuorumNeeded(Operation op) {
        QuorumType type = this.config.getType();
        switch (type) {
            case WRITE: {
                return QuorumImpl.isWriteOperation(op) && QuorumImpl.shouldCheckQuorum(op);
            }
            case READ: {
                return QuorumImpl.isReadOperation(op) && QuorumImpl.shouldCheckQuorum(op);
            }
            case READ_WRITE: {
                return (QuorumImpl.isReadOperation(op) || QuorumImpl.isWriteOperation(op)) && QuorumImpl.shouldCheckQuorum(op);
            }
        }
        throw new IllegalStateException("Unhandled quorum type: " + String.valueOf((Object)type));
    }

    private static boolean isReadOperation(Operation op) {
        return op instanceof ReadonlyOperation;
    }

    private static boolean isWriteOperation(Operation op) {
        return op instanceof MutatingOperation;
    }

    private static boolean shouldCheckQuorum(Operation op) {
        return !(op instanceof QuorumCheckAwareOperation) || ((QuorumCheckAwareOperation)((Object)op)).shouldCheckQuorum();
    }

    void ensureQuorumPresent(Operation op) {
        if (!this.isQuorumNeeded(op)) {
            return;
        }
        this.ensureQuorumPresent();
    }

    void ensureQuorumPresent() {
        if (!this.isPresent()) {
            throw this.newQuorumException();
        }
    }

    private QuorumException newQuorumException() {
        throw new QuorumException("Split brain protection exception: " + this.quorumName + " has failed!");
    }

    private void createAndPublishEvent(Collection<Member> memberList, boolean presence) {
        QuorumEvent quorumEvent = new QuorumEvent(this.nodeEngine.getThisAddress(), this.size, memberList, presence);
        this.eventService.publishEvent("hz:impl:quorumService", this.quorumName, (Object)quorumEvent, quorumEvent.hashCode());
    }

    private QuorumFunction initializeQuorumFunction() {
        QuorumFunction quorumFunction = this.config.getQuorumFunctionImplementation();
        if (quorumFunction == null && this.config.getQuorumFunctionClassName() != null) {
            try {
                quorumFunction = (QuorumFunction)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), this.config.getQuorumFunctionClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (quorumFunction == null) {
            quorumFunction = new MemberCountQuorumFunction(this.size);
        }
        ManagedContext managedContext = this.nodeEngine.getSerializationService().getManagedContext();
        quorumFunction = (QuorumFunction)managedContext.initialize(quorumFunction);
        return quorumFunction;
    }

    public String toString() {
        return "QuorumImpl{quorumName='" + this.quorumName + "', isPresent=" + this.isPresent() + ", size=" + this.size + ", config=" + String.valueOf(this.config) + ", quorumFunction=" + String.valueOf(this.quorumFunction) + "}";
    }

    private static enum QuorumState {
        INITIAL,
        PRESENT,
        ABSENT;

    }
}

