/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.replicatedmap.impl;

import com.atlassian.nutcluster.replicatedmap.impl.operation.EvictionOperation;
import com.atlassian.nutcluster.replicatedmap.impl.record.ReplicatedRecordStore;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.util.scheduler.EntryTaskScheduler;
import com.atlassian.nutcluster.util.scheduler.ScheduledEntry;
import com.atlassian.nutcluster.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;

public class ReplicatedMapEvictionProcessor
implements ScheduledEntryProcessor<Object, Object> {
    private ReplicatedRecordStore store;
    private NodeEngine nodeEngine;
    private int partitionId;

    public ReplicatedMapEvictionProcessor(ReplicatedRecordStore store, NodeEngine nodeEngine, int partitionId) {
        this.store = store;
        this.nodeEngine = nodeEngine;
        this.partitionId = partitionId;
    }

    @Override
    public void process(EntryTaskScheduler<Object, Object> scheduler, Collection<ScheduledEntry<Object, Object>> entries) {
        EvictionOperation evictionOperation = new EvictionOperation(this.store, entries);
        evictionOperation.setPartitionId(this.partitionId);
        this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:replicatedMapService", evictionOperation, this.nodeEngine.getThisAddress());
    }
}

