/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.replicatedmap.impl.operation;

import com.atlassian.nutcluster.cluster.memberselector.MemberSelectors;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.atlassian.nutcluster.replicatedmap.impl.ReplicatedMapService;
import com.atlassian.nutcluster.replicatedmap.impl.client.ReplicatedMapEntries;
import com.atlassian.nutcluster.replicatedmap.impl.operation.AbstractNamedSerializableOperation;
import com.atlassian.nutcluster.replicatedmap.impl.operation.ReplicateUpdateOperation;
import com.atlassian.nutcluster.replicatedmap.impl.operation.VersionResponsePair;
import com.atlassian.nutcluster.replicatedmap.impl.record.ReplicatedRecordStore;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.OperationService;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import com.atlassian.nutcluster.spi.partition.IPartitionService;
import java.io.IOException;
import java.util.Collection;

public class PutAllOperation
extends AbstractNamedSerializableOperation
implements MutatingOperation {
    private String name;
    private ReplicatedMapEntries entries;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, ReplicatedMapEntries entries) {
        this.name = name;
        this.entries = entries;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore store = service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        int partitionId = this.getPartitionId();
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        for (int i = 0; i < this.entries.size(); ++i) {
            Data key = this.entries.getKey(i);
            Data value = this.entries.getValue(i);
            if (partitionId != partitionService.getPartitionId(key)) continue;
            Object putResult = store.put(key, value);
            Data oldValue = this.getNodeEngine().toData(putResult);
            eventPublishingService.fireEntryListenerEvent(key, oldValue, value, this.name, this.getCallerAddress());
            VersionResponsePair response = new VersionResponsePair(putResult, store.getVersion());
            this.publishReplicationMessage(key, value, response);
        }
    }

    private void publishReplicationMessage(Data key, Data value, VersionResponsePair response) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Collection<Member> members = this.getNodeEngine().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        for (Member member : members) {
            Address address = member.getAddress();
            if (address.equals(this.getNodeEngine().getThisAddress())) continue;
            Operation op = new ReplicateUpdateOperation(this.name, key, value, 0L, response, false, this.getCallerAddress()).setPartitionId(this.getPartitionId()).setValidateTarget(false);
            operationService.invokeOnTarget(this.getServiceName(), op, address);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.entries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.entries = (ReplicatedMapEntries)in.readObject();
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

