/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.scheduledexecutor.impl.operations;

import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.scheduledexecutor.ScheduledTaskHandler;
import com.atlassian.nutcluster.scheduledexecutor.impl.ScheduledExecutorWaitNotifyKey;
import com.atlassian.nutcluster.scheduledexecutor.impl.operations.AbstractSchedulerOperation;
import com.atlassian.nutcluster.spi.BlockingOperation;
import com.atlassian.nutcluster.spi.ReadonlyOperation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import java.io.IOException;

public class GetResultOperation<V>
extends AbstractSchedulerOperation
implements BlockingOperation,
ReadonlyOperation {
    private String taskName;
    private ScheduledTaskHandler handler;
    private Object result;

    public GetResultOperation() {
    }

    public GetResultOperation(ScheduledTaskHandler handler) {
        super(handler.getSchedulerName());
        this.taskName = handler.getTaskName();
        this.handler = handler;
    }

    @Override
    public void run() throws Exception {
        this.result = this.getContainer().get(this.taskName);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new ScheduledExecutorWaitNotifyKey(this.getSchedulerName(), this.handler.toUrn());
    }

    @Override
    public boolean shouldWait() {
        return this.getContainer().shouldParkGetResult(this.taskName);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new NutclusterException());
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.taskName);
        out.writeUTF(this.handler.toUrn());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskName = in.readUTF();
        this.handler = ScheduledTaskHandler.of(in.readUTF());
    }
}

