/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.spi.impl.proxyservice.impl;

import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.core.DistributedObjectEvent;
import com.atlassian.nutcluster.core.DistributedObjectListener;
import com.atlassian.nutcluster.core.DistributedObjectUtil;
import com.atlassian.nutcluster.util.executor.StripedRunnable;
import java.util.Collection;

final class ProxyEventProcessor
implements StripedRunnable {
    private final Collection<DistributedObjectListener> listeners;
    private final DistributedObjectEvent.EventType type;
    private final String serviceName;
    private final String objectName;
    private final DistributedObject object;

    ProxyEventProcessor(Collection<DistributedObjectListener> listeners, DistributedObjectEvent.EventType eventType, String serviceName, String objectName, DistributedObject object) {
        this.listeners = listeners;
        this.type = eventType;
        this.serviceName = serviceName;
        this.objectName = objectName;
        this.object = object;
    }

    @Override
    public void run() {
        DistributedObjectEvent event = new DistributedObjectEvent(this.type, this.serviceName, this.objectName, this.object);
        block4: for (DistributedObjectListener listener : this.listeners) {
            switch (this.type) {
                case CREATED: {
                    listener.distributedObjectCreated(event);
                    continue block4;
                }
                case DESTROYED: {
                    listener.distributedObjectDestroyed(event);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unrecognized EventType:" + String.valueOf((Object)this.type));
        }
    }

    @Override
    public int getKey() {
        return DistributedObjectUtil.getName(this.object).hashCode();
    }
}

