define('applinks/common/oauth2/rest-provider', [
    'applinks/lib/aui',
    'applinks/common/rest-request',
    'applinks/common/preconditions'
], function (
    AJS,
    ApplinksRestRequest,
    Preconditions
) {
    function ApplinksOAuth2ProviderRestModule(version) {
        Preconditions.hasValue(version, 'version');
        this._version = version;
    }

    ApplinksOAuth2ProviderRestModule.prototype.baseUrl = function () {
        return AJS.contextPath() + '/rest/oauth2/' + this._version + '/';
    }

    ApplinksOAuth2ProviderRestModule.prototype._withPath = function (path) {
        return this.baseUrl() + path;
    };

    function ApplinksOAuthV1RestModule() {
        this.module = new ApplinksOAuth2ProviderRestModule('1.0');
    }

    ApplinksOAuthV1RestModule.prototype.client = function (clientId) {
        Preconditions.hasValue(clientId, 'config');
        return new ApplinksRestRequest(this.module._withPath('client/' + clientId));
    };

    return {
        V1: new ApplinksOAuthV1RestModule()
    }
});
