define('applinks/feature/status', [
    'applinks/lib/jquery',
    'applinks/common/preconditions'
], function(
    $,
    Preconditions
) {
    function processStatus(status) {
        // this is the place to adjust status client side if needed
        return status;
    }

    /**
     * Renders Applink Status lozenge.
     *
     * Supported options:
     *
     * `applink` {Object} (required) - the applink to render the status for, with a `status` property indicating applink status
     * `container` {HTMLElement} (required) - container to attach the status to
     * `clickable` {boolean} (optional, defaults to `true`) - render the lozenge as clickable
     * `extraClasses` {string} (optional, defaults to `undefined`) - extra classes to render on the status element
     *
     * @param {Object} options object to render the status with
     * @constructor
     */
    function ApplinkStatus(options) {
        Preconditions.hasValue(options, 'options');
        Preconditions.hasValue(options.applink, 'options.applink');
        Preconditions.hasValue(options.container, 'options.container');

        var $container = $(options.container),
            applink = options.applink;
       
        if (!applink.statusLoaded || !applink.status) {
            $container.append(applinks.status.loading(createTemplateData(options)));
        } else if (applink.status.working) {
            $container.append(applinks.status.working(createTemplateData(options)));
        } else if (applink.status.mobile) {
            $container.append(applinks.status.mobile(createTemplateData(options)));
        } else {
            $container.append(applinks.status.error(createTemplateData(options)));
        }
        $container.attr('data-status-loaded', applink.statusLoaded);
    }

    function createTemplateData(options) {
        var clickable = options.clickable !== false; // true by default, false only if explicitly false
        var status = options.applink.status && processStatus(options.applink.status);
        var extraClasses = options.extraClasses || '';

        return {
            status: status,
            clickable: clickable,
            extraClasses: extraClasses
        };
    }

    return {
        View: ApplinkStatus,
        processStatus: processStatus,
        /**
         * CSS selector for the authenticate link generated by the View component for statuses requiring remote 
         * authentication 
         */
        AUTHENTICATE_LINK_SELECTOR: '.status-remote-auth-required'
    };
});