import {
    getIntermediateIncomingApplicationLinkDetailsFromResponseData,
    getFinalIncomingApplicationLinkDetailsFromResponseData,
} from './validators/IncomingApplicationLinkDetails';

export function getPrefix() {
    // Note: it's a function rather than a constant because BASE_URL is changeable despite the use of
    // "constant" naming convention.
    return `${AppLinks.SPI.BASE_URL}/oauth2`;
}

function formatGetUrl(actionPath, parameters = null) {
    const formattedParametersPart = parameters
        ? '?' +
          Object.entries(parameters)
              .map(([key, value]) => {
                  return `${key}=${encodeURIComponent(value)}`;
              })
              .join('&')
        : '';

    return `${getPrefix()}/${actionPath}${formattedParametersPart}`;
}

export async function getCreateIncomingLinkIntermediateDetails(applicationUrl) {
    const url = formatGetUrl('applinks', {
        'display.url': applicationUrl,
        'rpc.url': applicationUrl,
    });

    const response = await fetch(url);
    const responseData = await response.json();

    if (!response.ok) {
        const error = new Error(
            'getCreateIncomingLinkIntermediateDetails: response not ok: ' + response.statusText
        );
        error.errors = responseData.errors;
        throw error;
    }

    return getIntermediateIncomingApplicationLinkDetailsFromResponseData(responseData);
}

export async function getUpdateIncomingLinkIntermediateDetails(applinkId) {
    const url = formatGetUrl(`applinks/${applinkId}/incoming`, {
        edit: true,
    });

    const response = await fetch(url);
    const responseData = await response.json();

    if (!response.ok) {
        const error = new Error(
            'getCreateIncomingLinkIntermediateDetails: response not ok: ' + response.statusText
        );
        error.errors = responseData.errors;
        throw error;
    }

    return getIntermediateIncomingApplicationLinkDetailsFromResponseData(responseData);
}

export async function postCreateIncomingLink(
    rpcUrl,
    displayUrl,
    incomingRedirectUri,
    incomingScopesString
) {
    const url = `${getPrefix()}/applinks`;

    const data = {
        rpcUrl,
        displayUrl,
        incomingRedirectUri,
        incomingScopes: incomingScopesString,
    };

    const response = await fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data),
    });

    if (!response.ok) {
        throw new Error('postCreateIncomingLink: response not ok: ' + response.statusText);
    }

    const responseData = await response.json();
    return getFinalIncomingApplicationLinkDetailsFromResponseData(responseData);
}

export async function putUpdateIncomingLink(applinkId, incomingRedirectUri, incomingScopesString) {
    const url = `${getPrefix()}/applinks/${applinkId}/incoming`;

    const data = {
        incomingRedirectUri,
        incomingScopes: incomingScopesString,
    };

    const response = await fetch(url, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data),
    });

    if (!response.ok) {
        throw new Error('putUpdateIncomingLink: response not ok: ' + response.statusText);
    }
}

export async function getIncomingLinkDetails(applinkId) {
    const url = formatGetUrl(`applinks/${applinkId}/incoming`);

    const response = await fetch(url);
    if (!response.ok) {
        throw new Error('getIncomingLinkDetails: response not ok: ' + response.statusText);
    }

    const responseData = await response.json();

    return getFinalIncomingApplicationLinkDetailsFromResponseData(responseData);
}
